/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageSaveYesNoDialog {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String dialog;
    protected final String yesDialog;
    protected final String noDialog;
    protected final String yesButtonText;
    protected final String noButtonText;

    public MessageSaveYesNoDialog(UUID uuid, String dialog, String yesDialog, String noDialog, String yesButtonText, String noButtonText) {
        this.uuid = uuid;
        this.dialog = dialog;
        this.yesDialog = yesDialog;
        this.noDialog = noDialog;
        this.yesButtonText = yesButtonText;
        this.noButtonText = noButtonText;
    }

    public String getDialog() {
        return this.dialog;
    }

    public String getYesDialog() {
        return this.yesDialog;
    }

    public String getNoDialog() {
        return this.noDialog;
    }

    public String getYesButtonText() {
        return this.yesButtonText;
    }

    public String getNoButtonText() {
        return this.noButtonText;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageSaveYesNoDialog message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageSaveYesNoDialog.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageSaveYesNoDialog message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String dialog = message.getDialog();
        if (dialog == null) {
            log.error("Invalid dialog {} for yes/no dialog and {} from {}", (Object)dialog, (Object)message, (Object)serverPlayer);
            return;
        }
        String yesDialog = message.getYesDialog();
        if (yesDialog == null) {
            log.error("Invalid yes dialog {} for yes/no dialog and {} from {}", (Object)yesDialog, (Object)message, (Object)serverPlayer);
            return;
        }
        String noDialog = message.getNoDialog();
        if (noDialog == null) {
            log.error("Invalid no dialog {} for yes/no dialog and {} from {}", (Object)noDialog, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        String noButtonText = message.getNoButtonText();
        String yesButtonText = message.getYesButtonText();
        log.debug("Saving yes/no dialog {} [{}] -> {} [{}] -> {} for {} from {}", (Object)dialog, (Object)yesButtonText, (Object)yesDialog, (Object)noButtonText, (Object)noDialog, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.setDialogType(DialogType.YES_NO);
        easyNPCEntity.setDialog(dialog);
        easyNPCEntity.setYesDialog(yesDialog);
        easyNPCEntity.setNoDialog(noDialog);
        if (yesButtonText != null && !yesButtonText.isBlank()) {
            easyNPCEntity.setYesDialogButton(yesButtonText);
        }
        if (noButtonText != null && !noButtonText.isBlank()) {
            easyNPCEntity.setNoDialogButton(noButtonText);
        }
    }
}

