/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SliderButton
extends AbstractSliderButton {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final OnChange onChange;
    private float initValue;
    private float minValue;
    private Type type = Type.UNKNOWN;
    protected float maxValue;
    private float valueFraction;
    private float targetValue;
    private float roundFactor = 100.0f;

    public SliderButton(int x, int y, int width, int height, String name, float initValue, Type type, OnChange onChange) {
        this(x, y, width, height, (Component)Component.m_237113_((String)name), initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, String name, float initValue, float minValue, float maxValue, OnChange onChange, Type type) {
        this(x, y, width, height, (Component)Component.m_237113_((String)name), initValue, minValue, maxValue, onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, Component name, float initValue, float minValue, float maxValue, OnChange onChange, Type type) {
        super(x, y, width, height, name, (double)initValue);
        this.initValue = initValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueFraction = maxValue - minValue;
        this.f_93577_ = (this.initValue - minValue) / this.valueFraction;
        if (this.minValue == 0.0f && this.maxValue == 360.0f || this.minValue == -180.0f && this.maxValue == 180.0f) {
            this.roundFactor = 1.0f;
        }
        this.onChange = onChange;
        this.type = type;
        this.updateTargetValue();
        this.m_5695_();
    }

    public void setDefaultValue(float value) {
        this.initValue = value;
        this.f_93577_ = (this.initValue - this.minValue) / this.valueFraction;
        this.m_5697_();
        this.m_5695_();
    }

    public void reset() {
        this.setDefaultValue(0.0f);
    }

    public void resetToDefault() {
        this.setDefaultValue(this.initValue);
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    private void updateTargetValue() {
        this.targetValue = (float)Math.round(((double)this.minValue + (double)this.valueFraction * this.f_93577_) * (double)this.roundFactor) / this.roundFactor;
    }

    protected void m_5695_() {
        switch (this.type) {
            case DEGREE: {
                this.m_93666_((Component)Component.m_237113_((String)(this.targetValue + "\u00b0")));
                break;
            }
            case SCALE: 
            case POSITION: {
                this.m_93666_((Component)Component.m_237113_((String)("" + this.targetValue)));
                break;
            }
            default: {
                this.m_93666_((Component)Component.m_237113_((String)("" + this.targetValue)));
            }
        }
    }

    protected void m_5697_() {
        this.updateTargetValue();
        this.onChange.onChange(this);
    }

    public static float getMinValue(Type type) {
        switch (type) {
            case DEGREE: {
                return -180.0f;
            }
            case SCALE: {
                return 0.1f;
            }
            case POSITION: {
                return -16.0f;
            }
        }
        return -100.0f;
    }

    public static float getMaxValue(Type type) {
        switch (type) {
            case DEGREE: {
                return 180.0f;
            }
            case SCALE: {
                return 10.0f;
            }
            case POSITION: {
                return 16.0f;
            }
        }
        return 100.0f;
    }

    public static enum Type {
        DEGREE,
        POSITION,
        SCALE,
        UNKNOWN;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnChange {
        public void onChange(SliderButton var1);
    }
}

