/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.ScreenHelper;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.menu.configuration.pose.DefaultPoseConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessage;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultPoseConfigurationScreen
extends PoseConfigurationScreen<DefaultPoseConfigurationMenu> {
    protected Button crouchingPoseButton;
    protected Button dyingPoseButton;
    protected Button fallFlyingPoseButton;
    protected Button longJumpPoseButton;
    protected Button sleepingPoseButton;
    protected Button spinAttackPoseButton;
    protected Button standingPoseButton;
    protected Button swimmingPoseButton;

    public DefaultPoseConfigurationScreen(DefaultPoseConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private static Button menuButton(int left, int top, String label, Button.OnPress onPress) {
        return DefaultPoseConfigurationScreen.menuButton(left, top, 100, "pose." + label, onPress);
    }

    private void checkPoseButtonState(Pose pose, ModelPose modelPose) {
        Pose currentPose = pose != null ? pose : this.entity.m_20089_();
        boolean isCustomModelPose = (modelPose != null ? modelPose : this.entity.getModelPose()) == ModelPose.CUSTOM;
        this.standingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.STANDING;
        this.crouchingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.CROUCHING;
        this.dyingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.DYING;
        this.fallFlyingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.FALL_FLYING;
        this.longJumpPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.LONG_JUMPING;
        this.sleepingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SLEEPING;
        this.spinAttackPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SPIN_ATTACK;
        this.swimmingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SWIMMING;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.defaultPoseButton.f_93623_ = false;
        int poseButtonLeft = this.contentLeftPos + 175;
        this.standingPoseButton = (Button)this.m_142416_((GuiEventListener)DefaultPoseConfigurationScreen.menuButton(poseButtonLeft, this.contentTopPos, "standing", button -> {
            NetworkMessage.poseChange(this.uuid, Pose.STANDING);
            this.checkPoseButtonState(Pose.STANDING, ModelPose.DEFAULT);
        }));
        this.crouchingPoseButton = (Button)this.m_142416_((GuiEventListener)DefaultPoseConfigurationScreen.menuButton(poseButtonLeft, this.contentTopPos + 24, "crouching", button -> {
            NetworkMessage.poseChange(this.uuid, Pose.CROUCHING);
            this.checkPoseButtonState(Pose.CROUCHING, ModelPose.DEFAULT);
        }));
        this.dyingPoseButton = (Button)this.m_142416_((GuiEventListener)DefaultPoseConfigurationScreen.menuButton(poseButtonLeft, this.contentTopPos + 48, "dying", button -> {
            NetworkMessage.poseChange(this.uuid, Pose.DYING);
            this.checkPoseButtonState(Pose.DYING, ModelPose.DEFAULT);
        }));
        this.fallFlyingPoseButton = (Button)this.m_142416_((GuiEventListener)DefaultPoseConfigurationScreen.menuButton(poseButtonLeft, this.contentTopPos + 72, "fall_flying", button -> {
            NetworkMessage.poseChange(this.uuid, Pose.FALL_FLYING);
            this.checkPoseButtonState(Pose.FALL_FLYING, ModelPose.DEFAULT);
        }));
        this.longJumpPoseButton = (Button)this.m_142416_((GuiEventListener)DefaultPoseConfigurationScreen.menuButton(poseButtonLeft, this.contentTopPos + 96, "long_jumping", button -> {
            NetworkMessage.poseChange(this.uuid, Pose.LONG_JUMPING);
            this.checkPoseButtonState(Pose.LONG_JUMPING, ModelPose.DEFAULT);
        }));
        this.sleepingPoseButton = (Button)this.m_142416_((GuiEventListener)DefaultPoseConfigurationScreen.menuButton(poseButtonLeft, this.contentTopPos + 120, "sleeping", button -> {
            NetworkMessage.poseChange(this.uuid, Pose.SLEEPING);
            this.checkPoseButtonState(Pose.SLEEPING, ModelPose.DEFAULT);
        }));
        this.spinAttackPoseButton = (Button)this.m_142416_((GuiEventListener)DefaultPoseConfigurationScreen.menuButton(poseButtonLeft, this.contentTopPos + 144, "spin_attack", button -> {
            NetworkMessage.poseChange(this.uuid, Pose.SPIN_ATTACK);
            this.checkPoseButtonState(Pose.SPIN_ATTACK, ModelPose.DEFAULT);
        }));
        this.swimmingPoseButton = (Button)this.m_142416_((GuiEventListener)DefaultPoseConfigurationScreen.menuButton(poseButtonLeft, this.contentTopPos + 168, "swimming", button -> {
            NetworkMessage.poseChange(this.uuid, Pose.SWIMMING);
            this.checkPoseButtonState(Pose.SWIMMING, ModelPose.DEFAULT);
        }));
        this.checkPoseButtonState(this.entity.m_20089_(), this.entity.getModelPose());
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        boolean entityInvisible = this.entity.m_20145_();
        this.entity.m_6842_(false);
        ScreenHelper.renderScaledEntityAvatar(this.contentLeftPos + 80, this.contentTopPos + 125, 36, (float)(this.contentLeftPos + 80) - this.xMouse, (float)(this.contentTopPos + 65) - this.yMouse, this.entity);
        this.entity.m_6842_(entityInvisible);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        DefaultPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)this.contentTopPos, (int)(this.contentLeftPos + 169), (int)(this.contentTopPos + 187), (int)-16777216);
        DefaultPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 1), (int)(this.contentLeftPos + 168), (int)(this.contentTopPos + 186), (int)-5592406);
        DefaultPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 125), (int)(this.contentLeftPos + 168), (int)(this.contentTopPos + 186), (int)-1433892728);
        DefaultPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 125), (int)(this.contentLeftPos + 168), (int)(this.contentTopPos + 130), (int)-1433892728);
    }
}

