/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.ScreenHelper;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.Profession;
import de.markusbordihn.easynpc.menu.configuration.skin.DefaultSkinConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultSkinConfigurationScreen
extends SkinConfigurationScreen<DefaultSkinConfigurationMenu> {
    private Button skinPreviousButton = null;
    private Button skinNextButton = null;
    private Button skinPreviousPageButton = null;
    private Button skinNextPageButton = null;
    private List<Button> skinButtons = new ArrayList<Button>();
    private static final float SKIN_NAME_SCALING = 0.7f;
    private int skinStartIndex = 0;
    private int maxSkinsPerPage = 10;
    private Profession[] professions;
    private Enum<?>[] variants;
    protected int numOfProfessions = 0;
    protected int numOfSkins = 0;
    protected int numOfVariants = 0;

    public DefaultSkinConfigurationScreen(DefaultSkinConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void renderSkins(PoseStack poseStack) {
        if (this.entity == null) {
            return;
        }
        int skinPosition = 0;
        this.skinButtons = new ArrayList<Button>();
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int variantIndex = this.numOfProfessions > 0 ? i / this.numOfProfessions : i;
            Profession profession = this.numOfProfessions > 0 ? this.professions[i - variantIndex * this.numOfProfessions] : null;
            Enum<?> variant = this.variants[variantIndex];
            int left = this.f_97735_ + (skinPosition > 4 ? -(this.skinPreviewWidth * 4) - 24 : 32) + skinPosition * this.skinPreviewWidth;
            int top = this.contentTopPos + 82 + (skinPosition > 4 ? 84 : 0);
            this.renderSkinEntity(poseStack, left, top, variant, profession);
            float topNamePos = ((float)top - 76.0f) / 0.7f;
            float leftNamePos = ((float)left - 21.0f) / 0.7f;
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 100.0);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(variant.name(), 12);
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237113_((String)variantName), leftNamePos, topNamePos, 43520);
            if (profession != null) {
                String professionName = TextUtils.normalizeString(profession.name(), 11);
                this.f_96547_.m_92889_(poseStack, (Component)Component.m_237113_((String)professionName), leftNamePos, topNamePos + 10.0f, 0);
            }
            poseStack.m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(PoseStack poseStack, int x, int y, Enum<?> variant, Profession profession) {
        int skinButtonLeft = x - 24;
        int skinButtonTop = y - 81;
        int skinButtonHeight = 84;
        ImageButton skinButton = new ImageButton(skinButtonLeft, skinButtonTop, this.skinPreviewWidth, skinButtonHeight, 0, -84, 84, Constants.TEXTURE_CONFIGURATION, button -> {
            NetworkMessage.variantChange(this.uuid, variant);
            if (profession != null) {
                NetworkMessage.professionChange(this.uuid, profession);
            }
            NetworkMessage.skinChange(this.uuid, SkinType.DEFAULT);
        });
        if (this.entity.getSkinType() == SkinType.DEFAULT && this.entity.getVariant().equals(variant) && (profession == null || this.entity.getProfession().equals((Object)profession))) {
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_CONFIGURATION);
            this.m_93228_(poseStack, skinButtonLeft, skinButtonTop, 0, skinButtonHeight, this.skinPreviewWidth, skinButtonHeight);
            poseStack.m_85849_();
        }
        ScreenHelper.renderEntityDefaultSkin(x, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.entity, variant, profession);
        this.skinButtons.add((Button)skinButton);
    }

    private void checkSkinButtonState() {
        boolean skinButtonShouldBeVisible;
        this.skinPreviousButton.f_93624_ = skinButtonShouldBeVisible = this.numOfSkins > this.maxSkinsPerPage;
        this.skinNextButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinPreviousPageButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinNextPageButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinPreviousButton.f_93623_ = this.skinStartIndex > 0;
        this.skinNextButton.f_93623_ = this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins;
        this.skinPreviousPageButton.f_93623_ = this.skinStartIndex - this.maxSkinsPerPage > 0;
        this.skinNextPageButton.f_93623_ = this.skinStartIndex + 1 + this.maxSkinsPerPage < this.numOfSkins;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.defaultSkinButton.f_93623_ = false;
        this.professions = this.entity.getProfessions();
        this.variants = this.entity.getVariants();
        this.numOfProfessions = this.entity.hasProfessions() ? this.professions.length : 0;
        this.numOfVariants = this.variants.length;
        this.numOfSkins = this.numOfProfessions > 0 ? this.numOfVariants * this.numOfProfessions : this.numOfVariants;
        log.debug("Found about {} skins with {} variants and {} professions.", (Object)this.numOfSkins, (Object)this.numOfVariants, (Object)this.numOfProfessions);
        int skinButtonTop = this.f_97736_ + 212;
        int skinButtonLeft = this.contentLeftPos;
        int skinButtonRight = this.f_97735_ + 269;
        this.skinPreviousPageButton = (Button)this.m_142416_((GuiEventListener)DefaultSkinConfigurationScreen.menuButton(skinButtonLeft, skinButtonTop, 20, (Component)Component.m_237115_((String)"<<"), onPress -> {
            this.skinStartIndex = this.skinStartIndex - this.maxSkinsPerPage > 0 ? (this.skinStartIndex -= this.maxSkinsPerPage) : 0;
            this.checkSkinButtonState();
        }));
        this.skinPreviousButton = (Button)this.m_142416_((GuiEventListener)DefaultSkinConfigurationScreen.menuButton(skinButtonLeft + 20, skinButtonTop, 20, (Component)Component.m_237115_((String)"<"), onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinButtonState();
        }));
        this.skinNextPageButton = (Button)this.m_142416_((GuiEventListener)DefaultSkinConfigurationScreen.menuButton(skinButtonRight, skinButtonTop, 20, (Component)Component.m_237115_((String)">>"), onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinButtonState();
        }));
        this.skinNextButton = (Button)this.m_142416_((GuiEventListener)DefaultSkinConfigurationScreen.menuButton(skinButtonRight - 20, skinButtonTop, 20, (Component)Component.m_237115_((String)">"), onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinButtonState();
        }));
        this.checkSkinButtonState();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderSkins(poseStack);
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6305_(poseStack, x, y, partialTicks);
            }
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        DefaultSkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)this.contentTopPos, (int)(this.contentLeftPos + 282), (int)(this.contentTopPos + 170), (int)-16777216);
        DefaultSkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 1), (int)(this.contentLeftPos + 281), (int)(this.contentTopPos + 169), (int)-5592406);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6375_(mouseX, mouseY, button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

