/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.markusbordihn.easynpc.commands.ConfigureCommand;
import de.markusbordihn.easynpc.commands.PresetCommand;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class CommandManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    protected CommandManager() {
    }

    @SubscribeEvent
    public static void handleRegisterCommandsEvent(RegisterCommandsEvent event) {
        log.info("Registering {} commands ...", (Object)"easy_npc");
        CommandDispatcher commandDispatcher = event.getDispatcher();
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"easy_npc").then(ConfigureCommand.register())).then(PresetCommand.register()));
    }

    public static void executeEntityCommand(String command, Entity entity, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        if (minecraftServer == null) {
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Entity {} Command: \"{}\" with permission level {}", (Object)entity, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.m_129892_();
        CommandSourceStack commandSourceStack = minecraftServer.m_129893_().m_81329_(entity).m_81325_(permissionLevel);
        CommandDispatcher commandDispatcher = commands.m_82094_();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.m_81324_()));
        commands.m_242674_(parseResults, command);
    }

    public static void executePlayerCommand(String command, ServerPlayer serverPlayer, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        if (minecraftServer == null) {
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Player {} Command: \"{}\" with permission level {}", (Object)serverPlayer, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.m_129892_();
        CommandSourceStack commandSourceStack = minecraftServer.m_129893_().m_81329_((Entity)serverPlayer).m_81325_(permissionLevel).m_81327_(serverPlayer.m_9236_());
        CommandDispatcher commandDispatcher = commands.m_82094_();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.m_81324_()));
        commands.m_242674_(parseResults, command);
    }

    public static void executeServerCommand(String command) {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        if (minecraftServer == null) {
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Server Command: {}", (Object)command);
        Commands commands = minecraftServer.m_129892_();
        CommandSourceStack commandSourceStack = minecraftServer.m_129893_().m_81324_();
        CommandDispatcher commandDispatcher = commands.m_82094_();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)commandSourceStack);
        commands.m_242674_(parseResults, command);
    }

    public static void executeUserCommand(String command) {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        if (minecraftServer == null) {
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute User Command: {}", (Object)command);
        Commands commands = minecraftServer.m_129892_();
        CommandSourceStack commandSourceStack = minecraftServer.m_129893_();
        CommandDispatcher commandDispatcher = commands.m_82094_();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)commandSourceStack);
        commands.m_242674_(parseResults, command);
    }
}

