/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.commands.CommandManager;
import de.markusbordihn.easynpc.data.action.ActionData;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.entity.EasyNPCEntityData;
import de.markusbordihn.easynpc.entity.EasyNPCEntityMenu;
import de.markusbordihn.easynpc.entity.ai.goal.CustomLookAtPlayerGoal;
import de.markusbordihn.easynpc.entity.ai.goal.ResetLookAtPlayerGoal;
import de.markusbordihn.easynpc.item.ModItems;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class EasyNPCEntity
extends EasyNPCEntityData {
    public static final MobCategory CATEGORY = MobCategory.MISC;

    public EasyNPCEntity(EntityType<? extends EasyNPCEntity> entityType, Level level, Enum<?> variant) {
        this(entityType, level);
        this.setVariant(variant);
    }

    public EasyNPCEntity(EntityType<? extends EasyNPCEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20331_(true);
    }

    public void finalizeSpawn() {
    }

    public void executeAction(ActionData actionData, ServerPlayer serverPlayer) {
        if (actionData == null || !actionData.isValid()) {
            return;
        }
        int permissionLevel = this.getActionPermissionLevel();
        log.debug("Execute action {} for {} with permission level {} ...", (Object)actionData, (Object)this, (Object)permissionLevel);
        if (actionData.shouldExecuteAsUser()) {
            CommandManager.executePlayerCommand(actionData.getAction((LivingEntity)this, serverPlayer), serverPlayer, actionData.getPermissionLevel(), actionData.isDebugEnabled());
        } else {
            CommandManager.executeEntityCommand(actionData.getAction((LivingEntity)this, serverPlayer), (Entity)this, permissionLevel, actionData.isDebugEnabled());
        }
    }

    public void openMainConfigurationMenu(ServerPlayer serverPlayer) {
        EasyNPCEntityMenu.openMainConfigurationMenu(serverPlayer, this);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(9, (Goal)new ResetLookAtPlayerGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new CustomLookAtPlayerGoal(this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new CustomLookAtPlayerGoal(this, Mob.class, 15.0f));
    }

    public void m_7023_(Vec3 vec3) {
        this.m_21043_((LivingEntity)this, this instanceof FlyingAnimal);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
        this.finalizeSpawn();
        return spawnGroupData;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (hand == InteractionHand.MAIN_HAND) {
                ItemStack handItem = player.m_21120_(hand);
                if (!handItem.m_41619_() && handItem.m_41720_() == ModItems.EASY_NPC_WAND.get()) {
                    this.openMainConfigurationMenu(serverPlayer);
                    return InteractionResult.PASS;
                }
                boolean hasInteractionAction = this.hasAction(ActionType.ON_INTERACTION);
                if ((player.m_7500_() || this.isOwner(serverPlayer)) && (!this.hasDialog() && !hasInteractionAction || player.m_6047_())) {
                    this.openMainConfigurationMenu(serverPlayer);
                    return InteractionResult.PASS;
                }
                if (hasInteractionAction) {
                    ActionData actionData = this.getActionData(ActionType.ON_INTERACTION);
                    this.executeAction(actionData, serverPlayer);
                }
                if (this.hasDialog()) {
                    EasyNPCEntityMenu.openDialogMenu(serverPlayer, this);
                }
            }
        }
        return InteractionResult.PASS;
    }
}

