/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.Profession;
import de.markusbordihn.easynpc.entity.data.CustomDataSerializers;
import de.markusbordihn.easynpc.entity.data.EntityActionData;
import de.markusbordihn.easynpc.entity.data.EntityAttackData;
import de.markusbordihn.easynpc.entity.data.EntityDialogData;
import de.markusbordihn.easynpc.entity.data.EntityModelData;
import de.markusbordihn.easynpc.entity.data.EntityOwnerData;
import de.markusbordihn.easynpc.entity.data.EntityScaleData;
import de.markusbordihn.easynpc.entity.data.EntitySkinData;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCEntityData
extends AgeableMob
implements Npc,
EntityActionData,
EntityAttackData,
EntityDialogData,
EntityModelData,
EntityOwnerData,
EntityScaleData,
EntitySkinData {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final EntityDataAccessor<Profession> DATA_PROFESSION = SynchedEntityData.m_135353_(EasyNPCEntityData.class, CustomDataSerializers.PROFESSION);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String DATA_POSE_TAG = "Pose";
    private static final String DATA_PROFESSION_TAG = "Profession";
    private static final String DATA_VARIANT_TAG = "Variant";
    private boolean isPreview = false;

    public EasyNPCEntityData(EntityType<? extends EasyNPCEntity> entityType, Level level) {
        super(entityType, level);
    }

    public Pose getPose(String pose) {
        return Pose.valueOf((String)pose);
    }

    public Profession getDefaultProfession() {
        return Profession.NONE;
    }

    public Profession getProfession() {
        return (Profession)((Object)this.f_19804_.m_135370_(DATA_PROFESSION));
    }

    public Profession getProfession(String name) {
        return Profession.valueOf(name);
    }

    public void setProfession(Profession profession) {
        this.f_19804_.m_135381_(DATA_PROFESSION, (Object)profession);
    }

    public void setProfession(String name) {
        Profession profession = this.getProfession(name);
        if (profession != null) {
            this.setProfession(profession);
        } else {
            log.error("Unknown profession {} for {}", (Object)name, (Object)this);
        }
    }

    public boolean hasProfessions() {
        return false;
    }

    public Profession[] getProfessions() {
        return Profession.values();
    }

    public boolean hasProfession() {
        return false;
    }

    public Component getProfessionName() {
        Profession profession = this.getProfession();
        return profession != null ? TextUtils.normalizeName(profession.name()) : Component.m_237113_((String)"");
    }

    public Enum<?> getDefaultVariant() {
        return Variant.STEVE;
    }

    public Enum<?> getVariant() {
        return this.getVariant((String)this.f_19804_.m_135370_(DATA_VARIANT));
    }

    public Enum<?> getVariant(String name) {
        return Variant.valueOf(name);
    }

    public void setVariant(Enum<?> variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)(variant != null ? variant.name() : ""));
    }

    public void setVariant(String name) {
        Enum<?> variant = this.getVariant(name);
        if (variant != null) {
            this.setVariant(variant);
        } else {
            log.error("Unknown variant {} for {}", (Object)name, (Object)this);
        }
    }

    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    public Component getVariantName() {
        Enum<?> variant = this.getVariant();
        return variant != null ? TextUtils.normalizeName(variant.name()) : this.m_5677_();
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public void setPreview(boolean isPreview) {
        this.isPreview = isPreview;
    }

    public CompoundTag exportPreset() {
        return this.serializeNBT();
    }

    public void importPreset(CompoundTag compoundTag) {
        this.m_20124_(Pose.STANDING);
        this.setModelPose(ModelPose.DEFAULT);
        this.clearActionData();
        if (!compoundTag.m_128441_("UUID") && !compoundTag.m_128441_("pos")) {
            CompoundTag existingCompoundTag = this.serializeNBT();
            if (existingCompoundTag.m_128441_("ModelData")) {
                existingCompoundTag.m_128473_("ModelData");
            }
            compoundTag = existingCompoundTag.m_128391_(compoundTag);
        }
        this.deserializeNBT(compoundTag);
    }

    public Component m_7755_() {
        Component component = this.m_7770_();
        return component != null ? TextUtils.removeAction(component) : this.m_5677_();
    }

    @Override
    public Level getEntityLevel() {
        return this.f_19853_;
    }

    @Override
    public <T> void setEntityData(EntityDataAccessor<T> entityDataAccessor, T entityData) {
        this.f_19804_.m_135381_(entityDataAccessor, entityData);
    }

    @Override
    public <T> T getEntityData(EntityDataAccessor<T> entityDataAccessor) {
        return (T)this.f_19804_.m_135370_(entityDataAccessor);
    }

    @Override
    public <T> void defineEntityData(EntityDataAccessor<T> entityDataAccessor, T entityData) {
        this.f_19804_.m_135372_(entityDataAccessor, entityData);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.defineSynchedActionData();
        this.defineSynchedAttackData();
        this.defineSynchedDialogData();
        this.defineSynchedModelData();
        this.defineSynchedOwnerData();
        this.defineSynchedScaleData();
        this.defineSynchedSkinData();
        this.f_19804_.m_135372_(DATA_PROFESSION, (Object)this.getDefaultProfession());
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().name());
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.addAdditionalActionData(compoundTag);
        this.addAdditionalAttackData(compoundTag);
        this.addAdditionalDialogData(compoundTag);
        this.addAdditionalModelData(compoundTag);
        this.addAdditionalOwnerData(compoundTag);
        this.addAdditionalScaleData(compoundTag);
        this.addAdditionalSkinData(compoundTag);
        if (this.getModelPose() == ModelPose.DEFAULT && this.m_20089_() != null) {
            compoundTag.m_128359_(DATA_POSE_TAG, this.m_20089_().name());
        } else {
            compoundTag.m_128359_(DATA_POSE_TAG, Pose.STANDING.name());
        }
        if (this.getProfession() != null) {
            compoundTag.m_128359_(DATA_PROFESSION_TAG, this.getProfession().name());
        }
        if (this.getVariant() != null) {
            compoundTag.m_128359_(DATA_VARIANT_TAG, this.getVariant().name());
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        String variant;
        String profession;
        String pose;
        super.m_7378_(compoundTag);
        this.readAdditionalActionData(compoundTag);
        this.readAdditionalAttackData(compoundTag);
        this.readAdditionalDialogData(compoundTag);
        this.readAdditionalModelData(compoundTag);
        this.readAdditionalOwnerData(compoundTag);
        this.readAdditionalScaleData(compoundTag);
        this.readAdditionalSkinData(compoundTag);
        if (this.getModelPose() == ModelPose.DEFAULT && compoundTag.m_128441_(DATA_POSE_TAG) && (pose = compoundTag.m_128461_(DATA_POSE_TAG)) != null && !pose.isEmpty()) {
            this.m_20124_(this.getPose(pose));
        }
        if (compoundTag.m_128441_(DATA_PROFESSION_TAG) && (profession = compoundTag.m_128461_(DATA_PROFESSION_TAG)) != null && !profession.isEmpty()) {
            this.setProfession(this.getProfession(profession));
        }
        if (compoundTag.m_128441_(DATA_VARIANT_TAG) && (variant = compoundTag.m_128461_(DATA_VARIANT_TAG)) != null && !variant.isEmpty()) {
            this.setVariant(this.getVariant(variant));
        }
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public int getEntityGuiScaling() {
        return 30;
    }

    public int getEntityGuiTop() {
        return 0;
    }

    public int getEntityDialogTop() {
        return 0;
    }

    public int getEntityDialogScaling() {
        return 50;
    }

    private static enum Variant {
        STEVE;

    }
}

