/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.data;

import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.entity.EasyNPCEntityData;
import de.markusbordihn.easynpc.entity.data.CustomDataSerializers;
import de.markusbordihn.easynpc.entity.data.EntityDataInterface;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;

public interface EntityDialogData
extends EntityDataInterface {
    public static final EntityDataAccessor<DialogType> DATA_DIALOG_TYPE = SynchedEntityData.m_135353_(EasyNPCEntityData.class, CustomDataSerializers.DIALOG_TYPE);
    public static final EntityDataAccessor<String> DATA_DIALOG = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_DIALOG_NO = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_DIALOG_NO_BUTTON = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_DIALOG_YES = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_DIALOG_YES_BUTTON = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final String DATA_DIALOG_NO_BUTTON_TAG = "DialogNoButton";
    public static final String DATA_DIALOG_NO_TAG = "DialogNo";
    public static final String DATA_DIALOG_TAG = "Dialog";
    public static final String DATA_DIALOG_TYPE_TAG = "DialogType";
    public static final String DATA_DIALOG_YES_BUTTON_TAG = "DialogYesButton";
    public static final String DATA_DIALOG_YES_TAG = "DialogYes";

    default public DialogType getDialogType() {
        return this.getEntityData(DATA_DIALOG_TYPE);
    }

    default public void setDialogType(DialogType dialogType) {
        this.setEntityData(DATA_DIALOG_TYPE, dialogType);
    }

    default public boolean hasDialog() {
        return !this.getEntityData(DATA_DIALOG).isEmpty() && this.getDialogType() != DialogType.NONE;
    }

    default public String getDialog() {
        return this.getEntityData(DATA_DIALOG);
    }

    default public void setDialog(String dialog) {
        this.setEntityData(DATA_DIALOG, dialog);
    }

    default public String getNoDialog() {
        return this.getEntityData(DATA_DIALOG_NO);
    }

    default public void setNoDialog(String dialog) {
        this.setEntityData(DATA_DIALOG_NO, dialog);
    }

    default public String getNoDialogButton() {
        return this.getEntityData(DATA_DIALOG_NO_BUTTON);
    }

    default public void setNoDialogButton(String dialogButton) {
        this.setEntityData(DATA_DIALOG_NO_BUTTON, dialogButton);
    }

    default public String getYesDialog() {
        return this.getEntityData(DATA_DIALOG_YES);
    }

    default public void setYesDialog(String dialog) {
        this.setEntityData(DATA_DIALOG_YES, dialog);
    }

    default public String getYesDialogButton() {
        return this.getEntityData(DATA_DIALOG_YES_BUTTON);
    }

    default public void setYesDialogButton(String dialogButton) {
        this.setEntityData(DATA_DIALOG_YES_BUTTON, dialogButton);
    }

    default public void defineSynchedDialogData() {
        this.defineEntityData(DATA_DIALOG, "");
        this.defineEntityData(DATA_DIALOG_TYPE, DialogType.NONE);
        this.defineEntityData(DATA_DIALOG_NO, "");
        this.defineEntityData(DATA_DIALOG_NO_BUTTON, "No");
        this.defineEntityData(DATA_DIALOG_YES, "");
        this.defineEntityData(DATA_DIALOG_YES_BUTTON, "Yes");
    }

    default public void addAdditionalDialogData(CompoundTag compoundTag) {
        if (this.getDialog() != null) {
            compoundTag.m_128359_(DATA_DIALOG_TAG, this.getDialog());
        }
        if (this.getDialogType() != null) {
            compoundTag.m_128359_(DATA_DIALOG_TYPE_TAG, this.getDialogType().name());
        }
        if (this.getNoDialog() != null) {
            compoundTag.m_128359_(DATA_DIALOG_NO_TAG, this.getNoDialog());
        }
        if (this.getNoDialogButton() != null) {
            compoundTag.m_128359_(DATA_DIALOG_NO_BUTTON_TAG, this.getNoDialogButton());
        }
        if (this.getYesDialog() != null) {
            compoundTag.m_128359_(DATA_DIALOG_YES_TAG, this.getYesDialog());
        }
        if (this.getYesDialogButton() != null) {
            compoundTag.m_128359_(DATA_DIALOG_YES_BUTTON_TAG, this.getYesDialogButton());
        }
    }

    default public void readAdditionalDialogData(CompoundTag compoundTag) {
        String dialogButton;
        String dialogType;
        String dialog;
        if (compoundTag.m_128441_(DATA_DIALOG_TAG) && (dialog = compoundTag.m_128461_(DATA_DIALOG_TAG)) != null) {
            this.setDialog(dialog);
        }
        if (compoundTag.m_128441_(DATA_DIALOG_TYPE_TAG) && (dialogType = compoundTag.m_128461_(DATA_DIALOG_TYPE_TAG)) != null && !dialogType.isEmpty()) {
            this.setDialogType(DialogType.get(dialogType));
        }
        if (compoundTag.m_128441_(DATA_DIALOG_NO_TAG) && (dialog = compoundTag.m_128461_(DATA_DIALOG_NO_TAG)) != null) {
            this.setNoDialog(dialog);
        }
        if (compoundTag.m_128441_(DATA_DIALOG_NO_BUTTON_TAG) && (dialogButton = compoundTag.m_128461_(DATA_DIALOG_NO_BUTTON_TAG)) != null) {
            this.setNoDialogButton(dialogButton);
        }
        if (compoundTag.m_128441_(DATA_DIALOG_YES_TAG) && (dialog = compoundTag.m_128461_(DATA_DIALOG_YES_TAG)) != null) {
            this.setYesDialog(dialog);
        }
        if (compoundTag.m_128441_(DATA_DIALOG_YES_BUTTON_TAG) && (dialogButton = compoundTag.m_128461_(DATA_DIALOG_YES_BUTTON_TAG)) != null) {
            this.setYesDialogButton(dialogButton);
        }
    }
}

