/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.data;

import de.markusbordihn.easynpc.entity.EasyNPCEntityData;
import de.markusbordihn.easynpc.entity.data.EntityDataInterface;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface EntityOwnerData
extends EntityDataInterface {
    public static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID_ID = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final String DATA_OWNER_TAG = "Owner";

    @Nullable
    default public UUID getOwnerUUID() {
        return this.getEntityData(DATA_OWNER_UUID_ID).orElse(null);
    }

    default public void setOwnerUUID(@Nullable UUID uuid) {
        this.setEntityData(DATA_OWNER_UUID_ID, Optional.ofNullable(uuid));
    }

    default public boolean hasOwner() {
        return this.getOwnerUUID() != null;
    }

    @Nullable
    default public LivingEntity getOwner() {
        Level level = this.getEntityLevel();
        if (level == null) {
            return null;
        }
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : level.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    default public String getOwnerName() {
        LivingEntity owner = this.getOwner();
        return owner == null ? "" : owner.m_7755_().getString();
    }

    default public boolean isOwner(ServerPlayer serverPlayer) {
        return serverPlayer != null ? this.isOwner(serverPlayer.m_20148_()) : false;
    }

    default public boolean isOwner(UUID uuid) {
        return uuid != null && this.hasOwner() && uuid.equals(this.getOwnerUUID());
    }

    default public void defineSynchedOwnerData() {
        this.defineEntityData(DATA_OWNER_UUID_ID, Optional.empty());
    }

    default public void addAdditionalOwnerData(CompoundTag compoundTag) {
        if (this.getOwnerUUID() != null) {
            compoundTag.m_128362_(DATA_OWNER_TAG, this.getOwnerUUID());
        }
    }

    default public void readAdditionalOwnerData(CompoundTag compoundTag) {
        UUID uuid;
        if (compoundTag.m_128403_(DATA_OWNER_TAG) && (uuid = compoundTag.m_128342_(DATA_OWNER_TAG)) != null) {
            this.setOwnerUUID(uuid);
        }
    }
}

