/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.data;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.EasyNPCEntityData;
import de.markusbordihn.easynpc.entity.data.CustomDataSerializers;
import de.markusbordihn.easynpc.entity.data.EntityDataInterface;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;

public interface EntitySkinData
extends EntityDataInterface {
    public static final EntityDataAccessor<String> DATA_SKIN = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_SKIN_URL = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Optional<UUID>> DATA_SKIN_UUID = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<SkinType> DATA_SKIN_TYPE = SynchedEntityData.m_135353_(EasyNPCEntityData.class, CustomDataSerializers.SKIN_TYPE);
    public static final String DATA_SKIN_TAG = "Skin";
    public static final String DATA_SKIN_TYPE_TAG = "SkinType";
    public static final String DATA_SKIN_URL_TAG = "SkinURL";
    public static final String DATA_SKIN_UUID_TAG = "SkinUUID";

    default public String getSkin() {
        return this.getEntityData(DATA_SKIN);
    }

    default public void setSkin(String skin) {
        this.setEntityData(DATA_SKIN, skin != null ? skin : "");
    }

    default public String getSkinURL() {
        return this.getEntityData(DATA_SKIN_URL);
    }

    default public void setSkinURL(String skinURL) {
        this.setEntityData(DATA_SKIN_URL, skinURL != null ? skinURL : "");
    }

    default public Optional<UUID> getSkinUUID() {
        return this.getEntityData(DATA_SKIN_UUID);
    }

    default public void setSkinUUID(UUID uuid) {
        this.setEntityData(DATA_SKIN_UUID, Optional.of(uuid));
    }

    default public void setSkinUUID(Optional<UUID> uuid) {
        this.setEntityData(DATA_SKIN_UUID, uuid);
    }

    default public SkinType getSkinType() {
        return this.getEntityData(DATA_SKIN_TYPE);
    }

    default public SkinType getSkinType(String name) {
        return SkinType.get(name);
    }

    default public void setSkinType(SkinType skinType) {
        this.setEntityData(DATA_SKIN_TYPE, skinType);
    }

    default public void setSkinType(String name) {
        SkinType skinType = this.getSkinType(name);
        if (skinType != null) {
            this.setSkinType(skinType);
        } else {
            log.error("Unknown skin type {} for {}", (Object)name, (Object)this);
        }
    }

    default public SkinModel getSkinModel() {
        return SkinModel.HUMANOID;
    }

    default public void defineSynchedSkinData() {
        this.defineEntityData(DATA_SKIN, "");
        this.defineEntityData(DATA_SKIN_URL, "");
        this.defineEntityData(DATA_SKIN_UUID, Optional.empty());
        this.defineEntityData(DATA_SKIN_TYPE, SkinType.DEFAULT);
    }

    default public void addAdditionalSkinData(CompoundTag compoundTag) {
        Optional<UUID> skinUUID;
        if (this.getSkin() != null) {
            compoundTag.m_128359_(DATA_SKIN_TAG, this.getSkin());
        }
        if (this.getSkinURL() != null) {
            compoundTag.m_128359_(DATA_SKIN_URL_TAG, this.getSkinURL());
        }
        if ((skinUUID = this.getSkinUUID()).isPresent()) {
            compoundTag.m_128362_(DATA_SKIN_UUID_TAG, skinUUID.get());
        }
        if (this.getSkinType() != null) {
            compoundTag.m_128359_(DATA_SKIN_TYPE_TAG, this.getSkinType().name());
        }
    }

    default public void readAdditionalSkinData(CompoundTag compoundTag) {
        String skinType;
        UUID skinUUID;
        String url;
        String skin;
        if (compoundTag.m_128441_(DATA_SKIN_TAG) && (skin = compoundTag.m_128461_(DATA_SKIN_TAG)) != null && !skin.isEmpty()) {
            this.setSkin(skin);
        }
        if (compoundTag.m_128441_(DATA_SKIN_URL_TAG) && (url = compoundTag.m_128461_(DATA_SKIN_URL_TAG)) != null && !url.isEmpty()) {
            this.setSkinURL(url);
        }
        if (compoundTag.m_128441_(DATA_SKIN_UUID_TAG) && (skinUUID = compoundTag.m_128342_(DATA_SKIN_UUID_TAG)) != null) {
            this.setSkinUUID(skinUUID);
        }
        if (compoundTag.m_128441_(DATA_SKIN_TYPE_TAG) && (skinType = compoundTag.m_128461_(DATA_SKIN_TYPE_TAG)) != null && !skinType.isEmpty()) {
            this.setSkinType(this.getSkinType(skinType));
        }
    }
}

