/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageDialogTypeChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final DialogType dialogType;

    public MessageDialogTypeChange(UUID uuid, DialogType dialogType) {
        this.uuid = uuid;
        this.dialogType = dialogType;
    }

    public DialogType getDialogType() {
        return this.dialogType;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageDialogTypeChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageDialogTypeChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageDialogTypeChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        DialogType dialogType = message.getDialogType();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || dialogType == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            log.error("Unable to save basic dialog with message {} from {}", (Object)message, (Object)context);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change dialog type: {} for {} from {}", (Object)dialogType, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.setDialogType(dialogType);
    }
}

