/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagePoseChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final Pose pose;

    public MessagePoseChange(UUID uuid, Pose pose) {
        this.uuid = uuid;
        this.pose = pose;
    }

    public Pose getPose() {
        return this.pose;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessagePoseChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePoseChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePoseChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        Pose pose = message.getPose();
        if (pose == null) {
            log.error("Invalid pose {} for {} from {}", (Object)pose, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change pose {} for {} from {}", (Object)pose, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.setModelPose(ModelPose.DEFAULT);
        easyNPCEntity.m_20124_(pose);
    }
}

