/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.WorldPresetData;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagePresetImportWorld {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final ResourceLocation resourceLocation;

    public MessagePresetImportWorld(UUID uuid, ResourceLocation resourceLocation) {
        this.uuid = uuid;
        this.resourceLocation = resourceLocation;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessagePresetImportWorld message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePresetImportWorld.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePresetImportWorld message, NetworkEvent.Context context) {
        CompoundTag compoundTag;
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ResourceLocation resourceLocation = message.getResourceLocation();
        if (resourceLocation == null) {
            log.error("Invalid resource location {} for {}", (Object)resourceLocation, (Object)serverPlayer);
            return;
        }
        Path presetPath = WorldPresetData.getPresetsResourceLocationPath(resourceLocation);
        if (!presetPath.toFile().exists()) {
            log.error("Preset {} does not exists for {}", (Object)resourceLocation, (Object)serverPlayer);
            return;
        }
        try {
            compoundTag = NbtIo.m_128937_((File)presetPath.toFile());
        }
        catch (IOException exception) {
            log.error("Failed to read NBT data from {}", (Object)resourceLocation, (Object)exception);
            return;
        }
        if (compoundTag == null) {
            log.error("Received empty preset {} for {}", (Object)resourceLocation, (Object)serverPlayer);
            return;
        }
        if (compoundTag.m_128441_("UUID")) {
            compoundTag.m_128473_("UUID");
        }
        if (compoundTag.m_128441_("Pos")) {
            compoundTag.m_128473_("Pos");
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (compoundTag.m_128441_("id") && !compoundTag.m_128461_("id").isEmpty() && !compoundTag.m_128461_("id").equals(easyNPCEntity.m_20078_())) {
            log.error("Invalid id {} for {} expected {} from {}", (Object)compoundTag.m_128461_("id"), (Object)easyNPCEntity, (Object)easyNPCEntity.m_20078_(), (Object)serverPlayer);
            return;
        }
        easyNPCEntity.importPreset(compoundTag);
    }
}

