/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageSkinChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String skin;
    protected final String skinURL;
    protected final UUID skinUUID;
    protected final String skinType;

    public MessageSkinChange(UUID uuid, String skin, String skinURL, UUID skinUUID, String skinType) {
        this.uuid = uuid;
        this.skin = skin;
        this.skinURL = skinURL;
        this.skinUUID = skinUUID;
        this.skinType = skinType;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSkin() {
        return this.skin;
    }

    public String getSkinURL() {
        return this.skinURL;
    }

    public UUID getSkinUUID() {
        return this.skinUUID;
    }

    public String getSkinType() {
        return this.skinType;
    }

    public static void handle(MessageSkinChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageSkinChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageSkinChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String skin = message.getSkin();
        if (skin == null) {
            log.error("Invalid skin {} for {} from {}", (Object)skin, (Object)message, (Object)serverPlayer);
            return;
        }
        String skinTypeName = message.getSkinType();
        if (skinTypeName == null || skinTypeName.isEmpty()) {
            log.error("Invalid skin type name {} for {} from {}", (Object)skin, (Object)message, (Object)serverPlayer);
            return;
        }
        SkinType skinType = SkinType.get(skinTypeName);
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        String skinURL = message.getSkinURL();
        UUID skinUUID = message.getSkinUUID();
        switch (skinType) {
            case CUSTOM: {
                log.debug("Setting custom skin for {} to {} from {}", (Object)easyNPCEntity, (Object)skinUUID, (Object)serverPlayer);
                easyNPCEntity.setSkinType(skinType);
                easyNPCEntity.setSkin("");
                easyNPCEntity.setSkinURL("");
                easyNPCEntity.setSkinUUID(skinUUID);
                break;
            }
            case DEFAULT: {
                log.debug("Setting default skin for {} to {} from {}", (Object)easyNPCEntity, (Object)skinType, (Object)serverPlayer);
                easyNPCEntity.setSkinType(skinType);
                easyNPCEntity.setSkin("");
                easyNPCEntity.setSkinURL("");
                easyNPCEntity.setSkinUUID(Constants.BLANK_UUID);
                break;
            }
            case PLAYER_SKIN: {
                log.debug("Setting player skin for {} to {} from {}", (Object)easyNPCEntity, (Object)skinURL, (Object)serverPlayer);
                easyNPCEntity.setSkinType(skinType);
                easyNPCEntity.setSkin("");
                easyNPCEntity.setSkinURL(skinURL != null && !skinURL.isBlank() ? skinURL : "");
                if (skinUUID != null && !Constants.BLANK_UUID.equals(skinUUID)) {
                    easyNPCEntity.setSkinUUID(skinUUID);
                    break;
                }
                UUID userUUID = PlayersUtils.getUserUUID(serverPlayer.m_20194_(), skin);
                if (!skin.equals(userUUID.toString())) {
                    log.debug("Converted user {} to UUID {} ...", (Object)skin, (Object)userUUID);
                }
                easyNPCEntity.setSkinUUID(userUUID);
                break;
            }
            case INSECURE_REMOTE_URL: 
            case SECURE_REMOTE_URL: {
                log.debug("Setting remote skin for {} to {} from {}", (Object)easyNPCEntity, (Object)skinURL, (Object)serverPlayer);
                easyNPCEntity.setSkinType(skinType);
                easyNPCEntity.setSkin("");
                easyNPCEntity.setSkinURL(skinURL != null && !skinURL.isBlank() ? skinURL : skin);
                easyNPCEntity.setSkinUUID(skinUUID != null && !Constants.BLANK_UUID.equals(skinUUID) ? skinUUID : UUID.nameUUIDFromBytes(skin.getBytes()));
                break;
            }
            default: {
                log.error("Failed processing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)skin, (Object)skinUUID, (Object)skinURL, (Object)skinType, (Object)easyNPCEntity, (Object)serverPlayer);
                easyNPCEntity.setSkinType(skinType);
                easyNPCEntity.setSkin(skin);
            }
        }
    }
}

