/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.CustomModelHelper;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import net.minecraft.client.model.AllayModel;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomAllayModel<T extends LivingEntity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart root;
    protected final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public CustomAllayModel(ModelPart modelPart) {
        this.root = modelPart.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.body = this.root.m_171324_("body");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftWing = this.body.m_171324_("left_wing");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public static LayerDefinition createBodyLayer() {
        return AllayModel.m_233340_();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof EasyNPCEntity) {
            EasyNPCEntity easyNPCEntity = (EasyNPCEntity)entity;
            CustomModelHelper.resetRotation(this.body);
            CustomModelHelper.resetRotation(this.head);
            CustomModelHelper.setRotation(this.leftArm, 0.0f, -0.27925268f, 0.0f);
            CustomModelHelper.setRotation(this.rightArm, 0.0f, 0.27925268f, 0.0f);
            CustomModelHelper.setPosition(this.root, 0.0f, 15.0f, 0.0f);
            CustomModelHelper.resetPosition(this.body);
            CustomModelHelper.resetPosition(this.head);
            CustomModelHelper.setPosition(this.leftArm, 2.0f, 0.0f, 0.0f);
            CustomModelHelper.setPosition(this.rightArm, -2.0f, 0.0f, 0.0f);
            this.body.f_104207_ = true;
            this.head.f_104207_ = true;
            this.leftArm.f_104207_ = true;
            this.rightArm.f_104207_ = true;
            if (easyNPCEntity.getModelPose() == ModelPose.CUSTOM) {
                CustomModelHelper.setHeadPositionRotationVisibility(this.head, easyNPCEntity.getModelHeadPosition(), easyNPCEntity.getModelHeadRotation(), easyNPCEntity.isModelHeadVisible(), netHeadYaw, headPitch);
                CustomModelHelper.setPositionRotationVisibility(this.body, easyNPCEntity.getModelBodyPosition(), easyNPCEntity.getModelBodyRotation(), easyNPCEntity.isModelBodyVisible());
                CustomModelHelper.setPositionRotationVisibility(this.rightArm, easyNPCEntity.getModelRightArmPosition(), easyNPCEntity.getModelRightArmRotation(), easyNPCEntity.isModelRightArmVisible());
                CustomModelHelper.setPositionRotationVisibility(this.leftArm, easyNPCEntity.getModelLeftArmPosition(), easyNPCEntity.getModelLeftArmRotation(), easyNPCEntity.isModelLeftArmVisible());
            } else if (easyNPCEntity.m_20089_() == Pose.CROUCHING) {
                this.body.f_104203_ = 0.5f;
                this.body.f_104201_ = 3.2f;
                this.head.f_104201_ = 4.2f;
                this.leftArm.f_104203_ += 0.4f;
                this.leftArm.f_104201_ = 2.2f;
                this.rightArm.f_104203_ += 0.4f;
                this.rightArm.f_104201_ = 2.2f;
            }
            if (easyNPCEntity.getModelPose() != ModelPose.CUSTOM && easyNPCEntity.m_20089_() != Pose.CROUCHING) {
                float bodyRotationAmount;
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                float ageAmount = ageInTicks * 9.0f * ((float)Math.PI / 180);
                float limbSwingRotation = Math.min(limbSwingAmount / 0.3f, 1.0f);
                this.body.f_104203_ = bodyRotationAmount = limbSwingRotation * 0.6981317f;
                this.root.f_104201_ += (float)Math.cos(ageAmount) * 0.25f * 1.0f - limbSwingRotation;
                float armRotationAmount = 0.43633232f - Mth.m_14089_((float)(ageAmount + 4.712389f)) * (float)Math.PI * 0.075f * 1.0f - limbSwingRotation;
                this.leftArm.f_104203_ = this.rightArm.f_104203_ = Mth.m_14179_((float)1.0f, (float)bodyRotationAmount, (float)Mth.m_14179_((float)limbSwingRotation, (float)-1.0471976f, (float)-0.7853982f));
                this.leftArm.f_104205_ = -armRotationAmount;
                this.rightArm.f_104205_ = armRotationAmount;
                this.rightArm.f_104204_ = 0.27925268f;
                this.leftArm.f_104204_ = -0.27925268f;
            }
            float wingRotationAmount = Mth.m_14089_((float)(ageInTicks * 20.0f * ((float)Math.PI / 180) + limbSwingAmount)) * (float)Math.PI * 0.15f;
            this.rightWing.f_104203_ = 0.43633232f;
            this.rightWing.f_104204_ = -0.61086524f + wingRotationAmount;
            this.leftWing.f_104203_ = 0.43633232f;
            this.leftWing.f_104204_ = 0.61086524f - wingRotationAmount;
        }
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0625f, 0.1875f);
        poseStack.m_252781_(Axis.f_252529_.m_252961_(this.rightArm.f_104203_));
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        poseStack.m_85837_(0.0625, 0.0, 0.0);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int lightLevel, int overlay, float unused1, float unused2, float unused3, float unused4) {
        this.root.m_104301_(poseStack, vertexConsumer, lightLevel, overlay);
    }
}

