/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.FairyModel;
import de.markusbordihn.easynpc.client.model.ModModelLayers;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.npc.Fairy;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FairyRenderer
extends HumanoidMobRenderer<EasyNPCEntity, FairyModel<EasyNPCEntity>> {
    protected static final Map<Fairy.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(Fairy.Variant.class), map -> {
        map.put(Fairy.Variant.BLUE, new ResourceLocation("easy_npc", "textures/entity/fairy/fairy_blue.png"));
        map.put(Fairy.Variant.GREEN, new ResourceLocation("easy_npc", "textures/entity/fairy/fairy_green.png"));
        map.put(Fairy.Variant.RED, new ResourceLocation("easy_npc", "textures/entity/fairy/fairy_red.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Fairy.Variant.GREEN);

    public FairyRenderer(EntityRendererProvider.Context context) {
        super(context, new FairyModel(context.m_174023_(ModModelLayers.FAIRY)), 0.3f);
    }

    public ResourceLocation getTextureLocation(EasyNPCEntity entity) {
        switch (entity.getSkinType()) {
            case CUSTOM: {
                return CustomTextureManager.getOrCreateTextureWithDefault(entity, DEFAULT_TEXTURE);
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                return PlayerTextureManager.getOrCreateTextureWithDefault(entity, DEFAULT_TEXTURE);
            }
        }
        return TEXTURE_BY_VARIANT.getOrDefault(entity.getVariant(), DEFAULT_TEXTURE);
    }

    protected void scale(EasyNPCEntity entity, PoseStack poseStack, float unused) {
        if (entity.m_6162_()) {
            poseStack.m_85841_(entity.getScaleX().floatValue() * 0.5f, entity.getScaleY().floatValue() * 0.5f, entity.getScaleZ().floatValue() * 0.5f);
        } else {
            poseStack.m_85841_(entity.getScaleX().floatValue(), entity.getScaleY().floatValue(), entity.getScaleZ().floatValue());
        }
    }

    public void render(EasyNPCEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        FairyModel playerModel = (FairyModel)this.m_7200_();
        Rotations rootRotation = entity.getModelRootRotation();
        if (rootRotation != null) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(rootRotation.m_123156_()));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(rootRotation.m_123157_()));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(rootRotation.m_123158_()));
            poseStack.m_85837_(0.0, -0.5, 0.0);
        }
        if (entity.getModelPose() == ModelPose.DEFAULT) {
            playerModel.f_102817_ = entity.m_6047_();
            switch (entity.m_20089_()) {
                case DYING: {
                    poseStack.m_85837_(-0.5, 0.0, 0.0);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)entity)));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                    playerModel.m_5585_().f_104203_ = -0.7853982f;
                    playerModel.m_5585_().f_104204_ = -0.7853982f;
                    playerModel.m_5585_().f_104205_ = -0.7853982f;
                    break;
                }
                case LONG_JUMPING: {
                    playerModel.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                    playerModel.f_102816_ = HumanoidModel.ArmPose.SPYGLASS;
                    break;
                }
                case SLEEPING: {
                    poseStack.m_85837_(0.5, 0.0, 0.0);
                    break;
                }
                case SPIN_ATTACK: {
                    playerModel.f_102815_ = HumanoidModel.ArmPose.BLOCK;
                    playerModel.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-35.0f));
                    break;
                }
                default: {
                    playerModel.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                    playerModel.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                    playerModel.m_5585_().f_104203_ = 0.0f;
                    playerModel.m_5585_().f_104204_ = 0.0f;
                    playerModel.m_5585_().f_104205_ = 0.0f;
                    break;
                }
            }
        } else {
            playerModel.f_102817_ = false;
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, light);
    }

    protected void renderNameTag(EasyNPCEntity entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int color) {
        Rotations rootRotation = entity.getModelRootRotation();
        if (rootRotation != null) {
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(-rootRotation.m_123156_()));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(-rootRotation.m_123157_()));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(-rootRotation.m_123158_()));
            poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        }
        super.m_7649_((Entity)entity, component, poseStack, multiBufferSource, color);
    }

    protected int getBlockLightLevel(EasyNPCEntity entity, BlockPos blockPos) {
        return 10;
    }
}

