/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.model.CustomZombieVillagerModel;
import de.markusbordihn.easynpc.client.renderer.entity.layers.ProfessionLayer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.VariantLayer;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.Profession;
import de.markusbordihn.easynpc.entity.npc.ZombieVillager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ZombieVillagerRenderer
extends MobRenderer<EasyNPCEntity, CustomZombieVillagerModel<EasyNPCEntity>> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    public static final ResourceLocation BASE_TEXTURE = new ResourceLocation("textures/entity/zombie_villager/zombie_villager.png");
    protected static final Map<Profession, ResourceLocation> TEXTURE_BY_PROFESSION = (Map)Util.m_137469_(new EnumMap(Profession.class), map -> {
        map.put(Profession.NONE, Constants.BLANK_ENTITY_TEXTURE);
        map.put(Profession.ARMORER, new ResourceLocation("textures/entity/zombie_villager/profession/armorer.png"));
        map.put(Profession.BUTCHER, new ResourceLocation("textures/entity/zombie_villager/profession/butcher.png"));
        map.put(Profession.CARTOGRAPHER, new ResourceLocation("textures/entity/zombie_villager/profession/cartographer.png"));
        map.put(Profession.CLERIC, new ResourceLocation("textures/entity/zombie_villager/profession/cleric.png"));
        map.put(Profession.FARMER, new ResourceLocation("textures/entity/zombie_villager/profession/farmer.png"));
        map.put(Profession.FISHERMAN, new ResourceLocation("textures/entity/zombie_villager/profession/fisherman.png"));
        map.put(Profession.FLETCHER, new ResourceLocation("textures/entity/zombie_villager/profession/fletcher.png"));
        map.put(Profession.LEATHERWORKER, new ResourceLocation("textures/entity/zombie_villager/profession/leatherworker.png"));
        map.put(Profession.LIBRARIAN, new ResourceLocation("textures/entity/zombie_villager/profession/librarian.png"));
        map.put(Profession.MASON, new ResourceLocation("textures/entity/zombie_villager/profession/mason.png"));
        map.put(Profession.NITWIT, new ResourceLocation("textures/entity/zombie_villager/profession/nitwit.png"));
        map.put(Profession.SHEPHERD, new ResourceLocation("textures/entity/zombie_villager/profession/shepherd.png"));
        map.put(Profession.TOOLSMITH, new ResourceLocation("textures/entity/zombie_villager/profession/toolsmith.png"));
        map.put(Profession.WEAPONSMITH, new ResourceLocation("textures/entity/zombie_villager/profession/weaponsmith.png"));
    });
    protected static final Map<ZombieVillager.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(ZombieVillager.Variant.class), map -> {
        map.put(ZombieVillager.Variant.DEFAULT, Constants.BLANK_ENTITY_TEXTURE);
        map.put(ZombieVillager.Variant.DESERT, new ResourceLocation("textures/entity/zombie_villager/type/desert.png"));
        map.put(ZombieVillager.Variant.JUNGLE, new ResourceLocation("textures/entity/zombie_villager/type/jungle.png"));
        map.put(ZombieVillager.Variant.PLAINS, new ResourceLocation("textures/entity/zombie_villager/type/plains.png"));
        map.put(ZombieVillager.Variant.SAVANNA, new ResourceLocation("textures/entity/zombie_villager/type/savanna.png"));
        map.put(ZombieVillager.Variant.SNOW, new ResourceLocation("textures/entity/zombie_villager/type/snow.png"));
        map.put(ZombieVillager.Variant.SWAMP, new ResourceLocation("textures/entity/zombie_villager/type/swamp.png"));
        map.put(ZombieVillager.Variant.TAIGA, new ResourceLocation("textures/entity/zombie_villager/type/taiga.png"));
    });

    public ZombieVillagerRenderer(EntityRendererProvider.Context context) {
        super(context, new CustomZombieVillagerModel(context.m_174023_(ModelLayers.f_171228_)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171229_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171230_))));
        this.m_115326_(new VariantLayer(this, context.m_174027_(), TEXTURE_BY_VARIANT));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_(new ProfessionLayer(this, context.m_174027_(), TEXTURE_BY_PROFESSION));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public ResourceLocation getProfessionTextureLocation(Enum<?> profession) {
        return TEXTURE_BY_PROFESSION.get(profession);
    }

    public ResourceLocation getVariantTextureLocation(Enum<?> variant) {
        return TEXTURE_BY_VARIANT.get(variant);
    }

    public ResourceLocation getTextureLocation(EasyNPCEntity entity) {
        switch (entity.getSkinType()) {
            case CUSTOM: {
                return CustomTextureManager.getOrCreateTextureWithDefault(entity, BASE_TEXTURE);
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                return PlayerTextureManager.getOrCreateTextureWithDefault(entity, BASE_TEXTURE);
            }
        }
        return BASE_TEXTURE;
    }

    protected void scale(EasyNPCEntity entity, PoseStack poseStack, float unused) {
        if (entity.m_6162_()) {
            poseStack.m_85841_(entity.getScaleX().floatValue() * 0.5f, entity.getScaleY().floatValue() * 0.5f, entity.getScaleZ().floatValue() * 0.5f);
            this.f_114477_ = 0.25f;
        } else {
            poseStack.m_85841_(entity.getScaleX().floatValue(), entity.getScaleY().floatValue(), entity.getScaleZ().floatValue());
            this.f_114477_ = 0.5f;
        }
    }

    public void render(EasyNPCEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        CustomZombieVillagerModel playerModel = (CustomZombieVillagerModel)this.m_7200_();
        Rotations rootRotation = entity.getModelRootRotation();
        if (rootRotation != null) {
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(rootRotation.m_123156_()));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(rootRotation.m_123157_()));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(rootRotation.m_123158_()));
            poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        }
        if (entity.getModelPose() == ModelPose.DEFAULT) {
            switch (entity.m_20089_()) {
                case DYING: {
                    poseStack.m_85837_(-1.0, 0.0, 0.0);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)entity)));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                    playerModel.m_5585_().f_104203_ = -0.7853982f;
                    playerModel.m_5585_().f_104204_ = -0.7853982f;
                    playerModel.m_5585_().f_104205_ = -0.7853982f;
                    break;
                }
                case SLEEPING: {
                    poseStack.m_85837_(1.0, 0.0, 0.0);
                    break;
                }
                default: {
                    playerModel.m_5585_().f_104203_ = 0.0f;
                    playerModel.m_5585_().f_104204_ = 0.0f;
                    playerModel.m_5585_().f_104205_ = 0.0f;
                    break;
                }
            }
        } else {
            playerModel.f_102817_ = false;
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, light);
    }

    protected void renderNameTag(EasyNPCEntity entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int color) {
        Rotations rootRotation = entity.getModelRootRotation();
        if (rootRotation != null) {
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(-rootRotation.m_123156_()));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(-rootRotation.m_123157_()));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(-rootRotation.m_123158_()));
            poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        }
        super.m_7649_((Entity)entity, component, poseStack, multiBufferSource, color);
    }

    protected int getBlockLightLevel(EasyNPCEntity entity, BlockPos blockPos) {
        return 7;
    }
}

