/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.config.CommonConfig;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationType;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ConfigurationScreen<T extends ConfigurationMenu>
extends AbstractContainerScreen<T> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    protected final ClientLevel clientLevel;
    protected final LocalPlayer localPlayer;
    protected final Minecraft minecraftInstance;
    protected final EasyNPCEntity entity;
    protected final SkinModel skinModel;
    protected final UUID uuid;
    protected Button closeButton = null;
    protected Button homeButton = null;
    protected float xMouse;
    protected float yMouse;
    protected int bottomPos;
    protected int buttonLeftPos;
    protected int buttonTopPos;
    protected int contentLeftPos;
    protected int contentTopPos;
    protected int rightPos;

    public ConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.entity = ((ConfigurationMenu)((Object)menu)).getEntity();
        this.skinModel = this.entity.getSkinModel();
        this.uuid = this.entity.m_20148_();
        this.minecraftInstance = Minecraft.m_91087_();
        this.localPlayer = this.minecraftInstance != null ? this.minecraftInstance.f_91074_ : null;
        this.clientLevel = this.minecraftInstance != null ? this.minecraftInstance.f_91073_ : null;
    }

    public void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.m_91152_((Screen)null);
        }
    }

    protected int fontDraw(PoseStack poseStack, String text, float x, float y) {
        return this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)("text.easy_npc.config." + text)), x, y, 0x404040);
    }

    protected static Button menuButton(int left, int top, int width, String label, Button.OnPress onPress) {
        return ConfigurationScreen.menuButton(left, top, width, (Component)Component.m_237115_((String)("text.easy_npc.config." + label)), onPress);
    }

    protected static Button menuButton(int left, int top, int width, String label, String data, Button.OnPress onPress) {
        return ConfigurationScreen.menuButton(left, top, width, (Component)Component.m_237110_((String)("text.easy_npc.config." + label), (Object[])new Object[]{data}), onPress);
    }

    protected static Button menuButton(int left, int top, int width, Component label, Button.OnPress onPress) {
        return Button.m_253074_((Component)label, (Button.OnPress)onPress).m_252987_(left, top, width, 20).m_253136_();
    }

    protected static Double getDoubleValue(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse double value: {}", (Object)value);
            }
        }
        return null;
    }

    protected boolean hasPermissions(Boolean enabled, Boolean allowInCreative, int permissionLevel) {
        if (Boolean.FALSE.equals(enabled)) {
            return false;
        }
        if (Boolean.TRUE.equals(allowInCreative != false && this.localPlayer != null) && this.localPlayer.m_7500_()) {
            return true;
        }
        return this.localPlayer != null && this.localPlayer.m_20310_(permissionLevel);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 242;
        this.f_97726_ = 300;
        this.f_97728_ = 8;
        this.f_97729_ = 7;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2 + 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.rightPos = this.f_97735_ + this.f_97726_;
        this.bottomPos = this.f_97736_ + this.f_97727_;
        this.buttonLeftPos = this.f_97735_ + 17;
        this.buttonTopPos = this.f_97736_ + 17;
        this.contentLeftPos = this.f_97735_ + 7;
        this.contentTopPos = this.f_97736_ + 43;
        this.closeButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.rightPos - 22, this.f_97736_ + 6, 10, 10, 60, 38, Constants.TEXTURE_CONFIGURATION, onPress -> this.closeScreen()));
        this.homeButton = (Button)this.m_142416_((GuiEventListener)ConfigurationScreen.menuButton(this.f_97735_ + 7, this.buttonTopPos, 10, (Component)Component.m_237113_((String)"<"), onPress -> NetworkMessage.openConfiguration(this.uuid, ConfigurationType.MAIN)));
    }

    public void m_86412_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_86412_(poseStack, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 250, 170);
        this.m_93228_(poseStack, this.f_97735_ + 243, this.f_97736_, 195, 0, 57, 170);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 77, 0, 5, 250, 170);
        this.m_93228_(poseStack, this.f_97735_ + 243, this.f_97736_ + 77, 195, 5, 57, 170);
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode != 257 && keyCode != 335 && keyCode != 69) {
            return super.m_7933_(keyCode, unused1, unused2);
        }
        if (keyCode == 257 || keyCode == 335) {
            return true;
        }
        return true;
    }
}

