/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String LOG_PREFIX = "[Custom Texture Manager]";
    private static HashMap<TextureModelKey, ResourceLocation> customTextureCache = new HashMap();

    protected CustomTextureManager() {
    }

    public static Map<TextureModelKey, ResourceLocation> getCustomTextureCache() {
        return customTextureCache;
    }

    public static Set<UUID> getCustomTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : customTextureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel())) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static ResourceLocation getOrCreateTextureWithDefault(EasyNPCEntity entity, ResourceLocation defaultResourceLocation) {
        Optional skinUUID = entity.getSkinUUID();
        if (!skinUUID.isPresent()) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey((UUID)skinUUID.get(), entity.getSkinModel());
        ResourceLocation resourceLocation = customTextureCache.get(textureModelKey);
        if (resourceLocation != null) {
            return resourceLocation;
        }
        return defaultResourceLocation;
    }

    public static ResourceLocation registerTexture(SkinModel skinModel, File textureFile) {
        UUID uuid = UUID.nameUUIDFromBytes(textureFile.getName().getBytes());
        TextureModelKey textureModelKey = new TextureModelKey(uuid, skinModel);
        return CustomTextureManager.registerTexture(textureModelKey, textureFile);
    }

    public static ResourceLocation registerTexture(TextureModelKey textureModelKey, File textureFile) {
        log.info("{} Registering custom texture {} with UUID {}.", (Object)LOG_PREFIX, (Object)textureFile.getName(), (Object)textureModelKey.getUUID());
        ResourceLocation resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            customTextureCache.put(textureModelKey, resourceLocation);
        }
        return resourceLocation;
    }

    public static void clearCustomTextureCache() {
        customTextureCache.clear();
    }
}

