/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.data.action.ActionUtils;
import de.markusbordihn.easynpc.network.message.MessageActionChange;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ActionData {
    public static final String DATA_ACTION_TAG = "Action";
    public static final String DATA_ACTION_TYPE_TAG = "ActionType";
    public static final String DATA_ACTION_EXECUTE_AS_USER_TAG = "ActionExecuteAsUser";
    public static final String DATA_ACTION_ENABLE_DEBUG_TAG = "ActionEnableDebug";
    public static final String DATA_ACTION_PERMISSION_LEVEL_TAG = "ActionPermissionLevel";
    private ActionType actionType = ActionType.NONE;
    private String action = "";
    private boolean enableDebug = false;
    private boolean executeAsUser = false;
    private int permissionLevel = 0;

    public ActionData(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public ActionData(ActionType actionType, String action) {
        this(actionType, action, 0);
    }

    public ActionData(ActionType actionType, String action, int permissionLevel) {
        this(actionType, action, permissionLevel, false);
    }

    public ActionData(ActionType actionType, String action, int permissionLevel, boolean executeAsUser) {
        this(actionType, action, permissionLevel, executeAsUser, false);
    }

    public ActionData(ActionType actionType, String action, boolean executeAsUser, boolean enableDebug) {
        this(actionType, action, 0, executeAsUser, enableDebug);
    }

    public ActionData(ActionType actionType, String action, int permissionLevel, boolean executeAsUser, boolean enableDebug) {
        this.action = action;
        this.actionType = actionType;
        this.enableDebug = enableDebug;
        this.executeAsUser = executeAsUser;
        this.permissionLevel = permissionLevel;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getActionTypeName() {
        return this.actionType.name();
    }

    public String getAction() {
        return this.action;
    }

    public String getAction(LivingEntity entity, ServerPlayer serverPlayer) {
        return ActionUtils.parseAction(this.action, entity, serverPlayer);
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setPermissionLevel(int permissionLevel) {
        this.permissionLevel = permissionLevel;
    }

    public boolean shouldExecuteAsUser() {
        return this.executeAsUser;
    }

    public void setExecuteAsUser(boolean executeAsUser) {
        this.executeAsUser = executeAsUser;
    }

    public boolean isDebugEnabled() {
        return this.enableDebug;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public boolean hasAction() {
        return this.action != null && !this.action.isEmpty();
    }

    public boolean hasActionType() {
        return this.actionType != null && this.actionType != ActionType.NONE;
    }

    public boolean isValid() {
        return this.actionType != ActionType.NONE && this.hasAction();
    }

    public void load(CompoundTag compoundTag) {
        this.actionType = ActionType.valueOf(compoundTag.m_128461_(DATA_ACTION_TYPE_TAG));
        this.action = compoundTag.m_128461_(DATA_ACTION_TAG);
        this.permissionLevel = compoundTag.m_128451_(DATA_ACTION_PERMISSION_LEVEL_TAG);
        this.executeAsUser = compoundTag.m_128471_(DATA_ACTION_EXECUTE_AS_USER_TAG);
        this.enableDebug = compoundTag.m_128471_(DATA_ACTION_ENABLE_DEBUG_TAG);
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128359_(DATA_ACTION_TYPE_TAG, this.getActionType().name());
        compoundTag.m_128359_(DATA_ACTION_TAG, this.getAction());
        compoundTag.m_128405_(DATA_ACTION_PERMISSION_LEVEL_TAG, this.getPermissionLevel());
        compoundTag.m_128379_(DATA_ACTION_EXECUTE_AS_USER_TAG, this.shouldExecuteAsUser());
        compoundTag.m_128379_(DATA_ACTION_ENABLE_DEBUG_TAG, this.isDebugEnabled());
        return compoundTag;
    }

    public static void encode(MessageActionChange message, FriendlyByteBuf buffer) {
        ActionData actionData = message.getActionData();
        buffer.m_130070_(actionData.getActionType().name());
        buffer.m_130070_(actionData.getAction());
        buffer.writeInt(actionData.getPermissionLevel());
        buffer.writeBoolean(actionData.shouldExecuteAsUser());
        buffer.writeBoolean(actionData.isDebugEnabled());
    }

    public static ActionData decode(FriendlyByteBuf buffer) {
        String actionType = buffer.m_130277_();
        String action = buffer.m_130277_();
        int permissionLevel = buffer.readInt();
        boolean executeAsUser = buffer.readBoolean();
        boolean enableDebug = buffer.readBoolean();
        return new ActionData(ActionType.valueOf(actionType), action, permissionLevel, executeAsUser, enableDebug);
    }

    public boolean equals(Object object) {
        if (object instanceof ActionData) {
            ActionData actionData = (ActionData)object;
            return this.getActionType() == actionData.getActionType() && this.getAction().equals(actionData.getAction()) && this.getPermissionLevel() == actionData.getPermissionLevel() && this.shouldExecuteAsUser() == actionData.shouldExecuteAsUser() && this.isDebugEnabled() == actionData.isDebugEnabled();
        }
        return this == object;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getActionType().hashCode();
        result = 31 * result + this.getAction().hashCode();
        result = 31 * result + this.getPermissionLevel();
        result = 31 * result + (this.shouldExecuteAsUser() ? 1 : 0);
        result = 31 * result + (this.isDebugEnabled() ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ActionData [actionType=" + this.getActionType() + ", action=" + this.getAction() + ", permissionLevel=" + this.getPermissionLevel() + ", executeAsUser=" + this.shouldExecuteAsUser() + ", enableDebug=" + this.isDebugEnabled() + "]";
    }
}

