/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.data;

import de.markusbordihn.easynpc.data.action.ActionData;
import de.markusbordihn.easynpc.data.action.ActionDataHelper;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.entity.EasyNPCEntityData;
import de.markusbordihn.easynpc.entity.data.EntityDataInterface;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;

public interface EntityActionData
extends EntityDataInterface {
    public static final EntityDataAccessor<CompoundTag> DATA_ACTION_DATA = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<Integer> DATA_ACTION_PERMISSION_LEVEL = SynchedEntityData.m_135353_(EasyNPCEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String DATA_ACTION_DATA_TAG = "ActionData";
    public static final String DATA_ACTION_PERMISSION_LEVEL_TAG = "ActionPermissionLevel";

    default public void setAction(ActionType actionType, ActionData actionData) {
        CompoundTag compoundTag = ActionDataHelper.setAction(this.getEntityData(DATA_ACTION_DATA), actionType, actionData);
        this.setEntityData(DATA_ACTION_DATA, compoundTag);
    }

    default public String getAction(ActionType actionType) {
        return ActionDataHelper.getAction(this.getEntityData(DATA_ACTION_DATA), actionType);
    }

    default public ActionData getActionData(ActionType actionType) {
        return ActionDataHelper.getActionData(this.getEntityData(DATA_ACTION_DATA), actionType);
    }

    default public void clearActionData() {
        this.setEntityData(DATA_ACTION_DATA, new CompoundTag());
    }

    default public boolean hasAction(ActionType actionType) {
        return ActionDataHelper.hasAction(this.getEntityData(DATA_ACTION_DATA), actionType);
    }

    default public Map<ActionType, ActionData> getActions() {
        return ActionDataHelper.readActionData(this.getEntityData(DATA_ACTION_DATA));
    }

    default public CompoundTag getActionData() {
        return this.getEntityData(DATA_ACTION_DATA);
    }

    default public void setActionData(CompoundTag compoundTag) {
        this.setEntityData(DATA_ACTION_DATA, compoundTag);
    }

    default public int getActionPermissionLevel() {
        return this.getEntityData(DATA_ACTION_PERMISSION_LEVEL);
    }

    default public void setActionPermissionLevel(int actionPermissionLevel) {
        this.setEntityData(DATA_ACTION_PERMISSION_LEVEL, actionPermissionLevel);
    }

    default public void defineSynchedActionData() {
        this.defineEntityData(DATA_ACTION_DATA, new CompoundTag());
        this.defineEntityData(DATA_ACTION_PERMISSION_LEVEL, 0);
    }

    default public void addAdditionalActionData(CompoundTag compoundTag) {
        if (ActionDataHelper.hasActionData(this.getActionData())) {
            compoundTag.m_128365_(DATA_ACTION_DATA_TAG, (Tag)this.getActionData());
        }
        compoundTag.m_128405_(DATA_ACTION_PERMISSION_LEVEL_TAG, this.getActionPermissionLevel());
    }

    default public void readAdditionalActionData(CompoundTag compoundTag) {
        if (compoundTag.m_128441_(DATA_ACTION_DATA_TAG)) {
            this.setActionData(compoundTag.m_128469_(DATA_ACTION_DATA_TAG));
        }
        if (compoundTag.m_128441_(DATA_ACTION_PERMISSION_LEVEL_TAG)) {
            this.setActionPermissionLevel(compoundTag.m_128451_(DATA_ACTION_PERMISSION_LEVEL_TAG));
        }
    }
}

