/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.action.ActionData;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageActionChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final ActionData actionData;
    protected final UUID uuid;

    public MessageActionChange(UUID uuid, ActionData actionData) {
        this.actionData = actionData;
        this.uuid = uuid;
    }

    public MessageActionChange(UUID uuid, ActionType actionType, String action) {
        this.actionData = new ActionData(actionType, action);
        this.uuid = uuid;
    }

    public ActionData getActionData() {
        return this.actionData;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageActionChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageActionChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageActionChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ActionData actionData = message.getActionData();
        if (actionData == null || !actionData.isValid()) {
            log.error("Invalid action data {} for {} from {}", (Object)actionData, (Object)message, (Object)serverPlayer);
            return;
        }
        int permissionLevel = 0;
        MinecraftServer minecraftServer = serverPlayer.m_20194_();
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (minecraftServer != null) {
            permissionLevel = minecraftServer.m_129944_(serverPlayer.m_36316_());
            easyNPCEntity.setActionPermissionLevel(permissionLevel);
        }
        ActionType actionType = actionData.getActionType();
        log.debug("Set action {}:{} for {} from {} with permission level {}.", (Object)actionType, (Object)actionData, (Object)easyNPCEntity, (Object)serverPlayer, (Object)permissionLevel);
        easyNPCEntity.setAction(actionType, actionData);
    }
}

