/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageModelVisibilityChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final ModelPart modelPart;
    protected final boolean visible;

    public MessageModelVisibilityChange(UUID uuid, ModelPart modelPart, boolean visible) {
        this.uuid = uuid;
        this.modelPart = modelPart;
        this.visible = visible;
    }

    public ModelPart getModelPart() {
        return this.modelPart;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageModelVisibilityChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelVisibilityChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelVisibilityChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ModelPart modelPart = message.getModelPart();
        if (modelPart == null) {
            log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            return;
        }
        boolean visible = message.isVisible();
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change {} visibility to {} for {} from {}", (Object)modelPart, (Object)visible, (Object)easyNPCEntity, (Object)serverPlayer);
        switch (modelPart) {
            case HEAD: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelHeadVisible(visible);
                break;
            }
            case BODY: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelBodyVisible(visible);
                break;
            }
            case ARMS: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelArmsVisible(visible);
                break;
            }
            case LEFT_ARM: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelLeftArmVisible(visible);
                break;
            }
            case RIGHT_ARM: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelRightArmVisible(visible);
                break;
            }
            case LEFT_LEG: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelLeftLegVisible(visible);
                break;
            }
            case RIGHT_LEG: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelRightLegVisible(visible);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            }
        }
    }
}

