/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageRemoveNPC {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;

    public MessageRemoveNPC(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageRemoveNPC message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageRemoveNPC.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageRemoveNPC message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.info("Removing Easy NPC {} requested by {}", (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.m_146870_();
    }
}

