/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Rotations;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageRotationChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final ModelPart modelPart;
    protected final Rotations rotations;

    public MessageRotationChange(UUID uuid, ModelPart modelPart, float x, float y, float z) {
        this(uuid, modelPart, new Rotations(x, y, z));
    }

    public MessageRotationChange(UUID uuid, ModelPart modelPart, Rotations rotations) {
        this.uuid = uuid;
        this.modelPart = modelPart;
        this.rotations = rotations;
    }

    public ModelPart getModelPart() {
        return this.modelPart;
    }

    public Rotations getRotations() {
        return this.rotations;
    }

    public float getX() {
        return this.rotations.m_123156_();
    }

    public float getY() {
        return this.rotations.m_123157_();
    }

    public float getZ() {
        return this.rotations.m_123158_();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageRotationChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageRotationChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageRotationChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ModelPart modelPart = message.getModelPart();
        if (modelPart == null) {
            log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            return;
        }
        Rotations rotations = message.getRotations();
        if (rotations == null) {
            log.error("Invalid rotation {} for {} from {}", (Object)rotations, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change {} rotation to {}\u00b0 for {} from {}", (Object)modelPart, (Object)rotations, (Object)easyNPCEntity, (Object)serverPlayer);
        switch (modelPart) {
            case HEAD: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelHeadRotation(rotations);
                break;
            }
            case BODY: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelBodyRotation(rotations);
                break;
            }
            case ARMS: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelArmsRotation(rotations);
                break;
            }
            case LEFT_ARM: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelLeftArmRotation(rotations);
                break;
            }
            case RIGHT_ARM: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelRightArmRotation(rotations);
                break;
            }
            case LEFT_LEG: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelLeftLegRotation(rotations);
                break;
            }
            case RIGHT_LEG: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelRightLegRotation(rotations);
                break;
            }
            case ROOT: {
                easyNPCEntity.setModelRootRotation(rotations);
                break;
            }
            default: {
                log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            }
        }
    }
}

