/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageSaveBasicDialog {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String dialog;

    public MessageSaveBasicDialog(UUID uuid, String dialog) {
        this.uuid = uuid;
        this.dialog = dialog;
    }

    public String getDialog() {
        return this.dialog;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageSaveBasicDialog message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageSaveBasicDialog.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageSaveBasicDialog message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        String dialog = message.getDialog();
        if (serverPlayer == null || dialog == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            log.error("Unable to save basic dialog with message {} from {}", (Object)message, (Object)context);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Saving basic dialog: {} for {} from {}", (Object)dialog, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.setDialogType(DialogType.BASIC);
        easyNPCEntity.setDialog(dialog);
    }
}

