/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageScaleChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final Float scale;
    protected final String scaleAxis;
    protected final UUID uuid;

    public MessageScaleChange(UUID uuid, String scaleAxis, Float scale) {
        this.uuid = uuid;
        this.scale = scale;
        this.scaleAxis = scaleAxis;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Float getScale() {
        return this.scale;
    }

    public String getScaleAxis() {
        return this.scaleAxis;
    }

    public static void handle(MessageScaleChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageScaleChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageScaleChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String scaleAxis = message.getScaleAxis();
        if (scaleAxis == null || !scaleAxis.equals("x") && !scaleAxis.equals("y") && !scaleAxis.equals("z")) {
            log.error("Unknown scale axis {} request for UUID {} from {}", (Object)scaleAxis, (Object)uuid, (Object)serverPlayer);
            return;
        }
        Float scale = message.getScale();
        if (scale == null || scale.floatValue() < 0.1f || scale.floatValue() > 10.0f) {
            log.error("Invalid scale {} request for UUID {} from {}", (Object)scale, (Object)uuid, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPCEntity == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        switch (scaleAxis) {
            case "x": {
                easyNPCEntity.setScaleX(scale);
                break;
            }
            case "y": {
                easyNPCEntity.setScaleY(scale);
                break;
            }
            case "z": {
                easyNPCEntity.setScaleZ(scale);
                break;
            }
            default: {
                log.error("Unknown scale axis {} request for UUID {} from {}", (Object)scaleAxis, (Object)uuid, (Object)serverPlayer);
            }
        }
    }
}

