/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.CustomAllayModel;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.npc.Allay;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AllayRenderer
extends MobRenderer<EasyNPCEntity, CustomAllayModel<EasyNPCEntity>> {
    protected static final Map<Allay.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(Allay.Variant.class), map -> {
        map.put(Allay.Variant.DEFAULT, new ResourceLocation("textures/entity/allay/allay.png"));
        map.put(Allay.Variant.LAVA, new ResourceLocation("easy_npc", "textures/entity/allay/allay_lava.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Allay.Variant.DEFAULT);

    public AllayRenderer(EntityRendererProvider.Context context) {
        super(context, new CustomAllayModel(context.m_174023_(ModelLayers.f_233547_)), 0.4f);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(EasyNPCEntity entity) {
        switch (entity.getSkinType()) {
            case CUSTOM: {
                return CustomTextureManager.getOrCreateTextureWithDefault(entity, DEFAULT_TEXTURE);
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                return PlayerTextureManager.getOrCreateTextureWithDefault(entity, DEFAULT_TEXTURE);
            }
        }
        return TEXTURE_BY_VARIANT.getOrDefault(entity.getVariant(), DEFAULT_TEXTURE);
    }

    protected void scale(EasyNPCEntity entity, PoseStack poseStack, float unused) {
        if (entity.m_6162_()) {
            poseStack.m_85841_(entity.getScaleX().floatValue() * 0.5f, entity.getScaleY().floatValue() * 0.5f, entity.getScaleZ().floatValue() * 0.5f);
        } else {
            poseStack.m_85841_(entity.getScaleX().floatValue(), entity.getScaleY().floatValue(), entity.getScaleZ().floatValue());
        }
    }

    public void render(EasyNPCEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        CustomAllayModel playerModel = (CustomAllayModel)this.m_7200_();
        Rotations rootRotation = entity.getModelRootRotation();
        if (rootRotation != null) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(rootRotation.m_123156_()));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(rootRotation.m_123157_()));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(rootRotation.m_123158_()));
            poseStack.m_85837_(0.0, -0.5, 0.0);
        }
        if (entity.getModelPose() == ModelPose.DEFAULT) {
            switch (entity.m_20089_()) {
                case DYING: {
                    poseStack.m_85837_(-0.25, 0.0, 0.0);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)entity)));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                    playerModel.getHead().f_104203_ = -0.7853982f;
                    playerModel.getHead().f_104204_ = -0.7853982f;
                    playerModel.getHead().f_104205_ = -0.7853982f;
                    break;
                }
                case SLEEPING: {
                    poseStack.m_85837_(0.25, 0.0, 0.0);
                    break;
                }
                case SPIN_ATTACK: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-35.0f));
                    break;
                }
                default: {
                    playerModel.getHead().f_104203_ = 0.0f;
                    playerModel.getHead().f_104204_ = 0.0f;
                    playerModel.getHead().f_104205_ = 0.0f;
                }
            }
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, light);
    }

    protected int getBlockLightLevel(EasyNPCEntity entity, BlockPos blockPos) {
        return 10;
    }
}

