/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.preset;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.menu.configuration.preset.DefaultImportPresetConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ImportDefaultPresetConfigurationScreen
extends ImportPresetConfigurationScreen<DefaultImportPresetConfigurationMenu> {
    protected Button importPresetButton;
    private ImportFileSelectionList presetSelectionList;
    protected static ResourceLocation selectedPreset;

    public ImportDefaultPresetConfigurationScreen(DefaultImportPresetConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public static void updateSelectedPreset(ResourceLocation resourceLocation) {
        selectedPreset = resourceLocation;
    }

    public void loadPresetConfirm(ResourceLocation resourceLocation) {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.uuid != null) {
                this.loadPreset(resourceLocation);
                minecraft.m_91152_((Screen)null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)Component.m_237110_((String)"text.easy_npc.preset.importQuestion", (Object[])new Object[]{resourceLocation.m_135815_().substring(resourceLocation.m_135815_().lastIndexOf("/") + 1)}), (Component)Component.m_237110_((String)"text.easy_npc.preset.importWarning", (Object[])new Object[]{this.entity.m_5446_().getString()}), (Component)Component.m_237115_((String)"text.easy_npc.preset.importButton"), CommonComponents.f_130656_));
    }

    public void loadPreset(ResourceLocation resourceLocation) {
        CompoundTag compoundTag;
        InputStream inputStream = null;
        try {
            Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation);
            if (resource.isPresent()) {
                inputStream = ((Resource)resource.get()).m_215507_();
            }
        }
        catch (IOException exception) {
            log.error("Failed to load resource {}", (Object)resourceLocation, (Object)exception);
            return;
        }
        if (inputStream == null) {
            log.error("Received empty input stream for {}", (Object)resourceLocation);
            return;
        }
        try {
            compoundTag = NbtIo.m_128939_((InputStream)inputStream);
        }
        catch (IOException exception) {
            log.error("Failed to read NBT data from {}", (Object)resourceLocation, (Object)exception);
            return;
        }
        if (compoundTag == null) {
            log.error("Received empty preset {}", (Object)resourceLocation);
            return;
        }
        if (compoundTag.m_128441_("UUID")) {
            compoundTag.m_128473_("UUID");
        }
        if (compoundTag.m_128441_("Pos")) {
            compoundTag.m_128473_("Pos");
        }
        NetworkMessage.importPreset(this.uuid, compoundTag);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.defaultImportPresetButton.f_93623_ = false;
        this.presetSelectionList = new ImportFileSelectionList(this.f_96541_);
        this.m_7787_((GuiEventListener)this.presetSelectionList);
        ImportDefaultPresetConfigurationScreen.updateSelectedPreset(null);
        this.importPresetButton = (Button)this.m_142416_((GuiEventListener)ImportDefaultPresetConfigurationScreen.menuButton(this.buttonLeftPos + 25, this.bottomPos - 40, 220, "import_default_preset", button -> {
            if (selectedPreset != null) {
                this.loadPresetConfirm(selectedPreset);
            }
        }));
        this.importPresetButton.f_93623_ = false;
    }

    @Override
    public void m_86412_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_86412_(poseStack, x, y, partialTicks);
        this.presetSelectionList.m_86412_(poseStack, x, y, partialTicks);
        this.importPresetButton.f_93623_ = selectedPreset != null;
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int fileListTop = this.f_97736_ + 55;
        int fileListHeight = fileListTop + 110;
        int fileListWidth = this.f_97735_ + 290;
        ImportDefaultPresetConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos - 1), (int)(fileListTop - 1), (int)(fileListWidth + 1), (int)(fileListHeight + 1), (int)-16777216);
        ImportDefaultPresetConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)fileListTop, (int)fileListWidth, (int)fileListHeight, (int)-5592406);
        ImportDefaultPresetConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos - 1), (int)(fileListTop - 4), (int)(fileListWidth + 1), (int)(fileListTop + 12), (int)-16777216);
        ImportDefaultPresetConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(fileListTop - 3), (int)fileListWidth, (int)(fileListTop + 11), (int)-7829368);
        this.f_96547_.m_92763_(poseStack, (Component)Component.m_237110_((String)"text.easy_npc.config.preset_default_for", (Object[])new Object[]{this.skinModel}), (float)this.contentLeftPos + 3.0f, (float)fileListTop, 0xFFFFFF);
    }

    @OnlyIn(value=Dist.CLIENT)
    class ImportFileSelectionList
    extends ObjectSelectionList<Entry> {
        public ImportFileSelectionList(Minecraft minecraft) {
            super(minecraft, ImportDefaultPresetConfigurationScreen.this.f_96543_ - 5, ImportDefaultPresetConfigurationScreen.this.f_96544_ - 150 + 66, ImportDefaultPresetConfigurationScreen.this.f_97736_ + 66, ImportDefaultPresetConfigurationScreen.this.f_96544_ - 150 - ImportDefaultPresetConfigurationScreen.this.f_97736_ + 66, 14);
            this.m_93473_(false, 0);
            this.m_93488_(false);
            this.m_93496_(false);
            Minecraft.m_91087_().m_91098_().m_214159_("preset", resourceLocation -> resourceLocation.toString().endsWith(".npc.nbt")).forEach((resourceLocation, resource) -> {
                if (!resourceLocation.m_135815_().toLowerCase().startsWith("preset/" + ImportDefaultPresetConfigurationScreen.this.skinModel.toString().toLowerCase() + "/")) {
                    log.warn("Skipping preset file {} as it does not match the current skin model {}", resourceLocation, (Object)ImportDefaultPresetConfigurationScreen.this.skinModel.toString().toLowerCase());
                    return;
                }
                Entry entry = new Entry((ResourceLocation)resourceLocation, ImportDefaultPresetConfigurationScreen.this.skinModel);
                this.m_7085_((AbstractSelectionList.Entry)entry);
            });
        }

        protected int m_5756_() {
            return super.m_5756_() + 12;
        }

        public int m_5759_() {
            return super.m_5759_() + 40;
        }

        public boolean m_93696_() {
            return ImportDefaultPresetConfigurationScreen.this.m_7222_() == this;
        }

        public void m_86412_(PoseStack poseStack, int x, int y, float partialTicks) {
            if (this.m_5773_() > 0) {
                super.m_86412_(poseStack, x, y, partialTicks);
                return;
            }
            ImportDefaultPresetConfigurationScreen.this.f_96547_.m_92763_(poseStack, (Component)Component.m_237115_((String)"text.easy_npc.config.no_presets_found"), (float)ImportDefaultPresetConfigurationScreen.this.contentLeftPos + 80.0f, (float)ImportDefaultPresetConfigurationScreen.this.f_97736_ + 105.0f, 0xFFFFFF);
        }

        @OnlyIn(value=Dist.CLIENT)
        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final ResourceLocation resourceLocation;
            final SkinModel skinModel;
            final String fileName;

            public Entry(ResourceLocation resourceLocation, SkinModel skinModel) {
                this.resourceLocation = resourceLocation;
                this.skinModel = skinModel;
                this.fileName = this.resourceLocation.m_135827_() + ":" + this.resourceLocation.m_135815_().replace("preset/" + this.skinModel.toString().toLowerCase() + "/", "").replace(".npc.nbt", "");
            }

            public void m_6311_(PoseStack poseStack, int x, int y, int unused1, int unused2, int unused3, int unused4, int unused5, boolean unused6, float partialTicks) {
                ImportDefaultPresetConfigurationScreen.this.f_96547_.m_92756_(poseStack, this.fileName, (float)ImportFileSelectionList.this.f_93388_ / 2.0f - (float)ImportDefaultPresetConfigurationScreen.this.f_96547_.m_92895_(this.fileName) / 2.0f, (float)y + 1.0f, 0xFFFFFF, true);
            }

            public boolean m_6375_(double unused1, double unused2, int button) {
                if (button == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                ImportFileSelectionList.this.m_6987_((AbstractSelectionList.Entry)this);
                ImportDefaultPresetConfigurationScreen.updateSelectedPreset(this.resourceLocation);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.resourceLocation.m_135815_());
            }
        }
    }
}

