/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.ScreenHelper;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.CustomSkinData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.menu.configuration.skin.CustomSkinConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class CustomSkinConfigurationScreen
extends SkinConfigurationScreen<CustomSkinConfigurationMenu> {
    private Button skinNextButton = null;
    private Button skinNextPageButton = null;
    private Button skinPreviousButton = null;
    private Button skinPreviousPageButton = null;
    protected Button skinFolderButton = null;
    protected Button skinReloadButton = null;
    private List<Button> skinButtons = new ArrayList<Button>();
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_RELOAD_DELAY = 5;
    private int skinStartIndex = 0;
    private int maxSkinsPerPage = 5;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();
    protected int numberOfTextLines = 1;
    protected int numOfSkins = 0;
    protected int lastNumOfSkins = 0;
    protected static int nextSkinReload = (int)Instant.now().getEpochSecond();

    public CustomSkinConfigurationScreen(CustomSkinConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void renderSkins(PoseStack poseStack) {
        if (this.entity == null) {
            return;
        }
        int positionTop = 119;
        int skinPosition = 0;
        this.skinButtons = new ArrayList<Button>();
        Set<UUID> textures = CustomTextureManager.getCustomTextureCacheKeys(this.skinModel);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.f_97735_ + 32 + skinPosition * this.skinPreviewWidth;
            int top = this.f_97736_ + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(poseStack, left, top, this.skinModel, textureKey);
            float topNamePos = ((float)top - 76.0f) / 0.7f;
            float leftNamePos = ((float)left - 21.0f) / 0.7f;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 100.0f);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(textureKey.toString(), 11);
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237113_((String)variantName), leftNamePos, topNamePos, 43520);
            poseStack.m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(PoseStack poseStack, int x, int y, SkinModel skinModel, UUID textureUUID) {
        TextureModelKey textureModelKey = new TextureModelKey(textureUUID, skinModel);
        int skinButtonLeft = x - 24;
        int skinButtonTop = y - 81;
        int skinButtonHeight = 84;
        ImageButton skinButton = new ImageButton(skinButtonLeft, skinButtonTop, this.skinPreviewWidth, skinButtonHeight, 0, -84, 84, Constants.TEXTURE_CONFIGURATION, button -> {
            log.info("Change custom skin ... {} {}", (Object)textureModelKey);
            NetworkMessage.skinChange(this.uuid, "", "", textureUUID, SkinType.CUSTOM);
        });
        Optional skinUUID = this.entity.getSkinUUID();
        if (skinUUID.isPresent() && ((UUID)skinUUID.get()).equals(textureUUID)) {
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_CONFIGURATION);
            CustomSkinConfigurationScreen.m_93228_((PoseStack)poseStack, (int)skinButtonLeft, (int)skinButtonTop, (int)0, (int)skinButtonHeight, (int)this.skinPreviewWidth, (int)skinButtonHeight);
            poseStack.m_85849_();
        }
        ScreenHelper.renderEntityPlayerSkin(x, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.entity, textureUUID, SkinType.CUSTOM);
        this.skinButtons.add((Button)skinButton);
    }

    private void checkSkinButtonState() {
        boolean skinButtonShouldBeVisible;
        this.skinPreviousButton.f_93624_ = skinButtonShouldBeVisible = this.numOfSkins > this.maxSkinsPerPage;
        this.skinNextButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinPreviousPageButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinNextPageButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinPreviousButton.f_93623_ = this.skinStartIndex > 0;
        this.skinNextButton.f_93623_ = this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins;
        this.skinPreviousPageButton.f_93623_ = this.skinStartIndex - this.maxSkinsPerPage > 0;
        this.skinNextPageButton.f_93623_ = this.skinStartIndex + 1 + this.maxSkinsPerPage < this.numOfSkins;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.customSkinButton.f_93623_ = false;
        this.numOfSkins = CustomTextureManager.getCustomTextureCacheKeys(this.skinModel).size();
        int skinButtonTop = this.f_97736_ + 187;
        int skinButtonLeft = this.contentLeftPos;
        int skinButtonRight = this.rightPos - 31;
        this.skinPreviousPageButton = (Button)this.m_142416_((GuiEventListener)CustomSkinConfigurationScreen.menuButton(skinButtonLeft, skinButtonTop, 20, (Component)Component.m_237113_((String)"<<"), onPress -> {
            this.skinStartIndex = this.skinStartIndex - this.maxSkinsPerPage > 0 ? (this.skinStartIndex -= this.maxSkinsPerPage) : 0;
            this.checkSkinButtonState();
        }));
        this.skinPreviousButton = (Button)this.m_142416_((GuiEventListener)CustomSkinConfigurationScreen.menuButton(skinButtonLeft + 20, skinButtonTop, 20, (Component)Component.m_237113_((String)"<"), onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinButtonState();
        }));
        this.skinNextPageButton = (Button)this.m_142416_((GuiEventListener)CustomSkinConfigurationScreen.menuButton(skinButtonRight, skinButtonTop, 20, (Component)Component.m_237113_((String)">>"), onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinButtonState();
        }));
        this.skinNextButton = (Button)this.m_142416_((GuiEventListener)CustomSkinConfigurationScreen.menuButton(skinButtonRight - 20, skinButtonTop, 20, (Component)Component.m_237113_((String)">"), onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinButtonState();
        }));
        this.checkSkinButtonState();
        Path skinModelFolder = CustomSkinData.getSkinDataFolder(this.skinModel);
        if (skinModelFolder != null) {
            this.skinFolderButton = (Button)this.m_142416_((GuiEventListener)CustomSkinConfigurationScreen.menuButton(this.contentLeftPos + 10, skinButtonTop - 114, 263, "open_textures_folder", this.skinModel.toString(), onPress -> Util.m_137581_().m_137644_(skinModelFolder.toFile())));
        }
        this.skinReloadButton = (Button)this.m_142416_((GuiEventListener)CustomSkinConfigurationScreen.menuButton(this.contentLeftPos + 60, skinButtonTop, 160, "reload_textures", onPress -> {
            CustomSkinData.refreshRegisterTextureFiles();
            nextSkinReload = (int)Instant.now().getEpochSecond() + 5;
        }));
        this.textComponents = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"text.easy_npc.config.custom_skin_text"), this.f_97726_ - 20);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    public void m_86412_(PoseStack poseStack, int x, int y, float partialTicks) {
        boolean canSkinReload;
        super.m_86412_(poseStack, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                float f = (float)this.f_97735_ + 10.0f;
                float f2 = (float)this.f_97736_ + 45.0f;
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92877_(poseStack, formattedCharSequence, f, f2 + (float)(line * (9 + 2)), 0x404040);
            }
        }
        boolean bl = canSkinReload = Instant.now().getEpochSecond() >= (long)nextSkinReload;
        if (!canSkinReload) {
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)"text.easy_npc.config.skin_reloading"), (float)this.f_97735_ + 55.0f, (float)this.f_97736_ + 215.0f, 0xFF5555);
        }
        this.skinReloadButton.f_93623_ = canSkinReload;
        this.renderSkins(poseStack);
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_86412_(poseStack, x, y, partialTicks);
            }
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        CustomSkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(this.f_97736_ + 102), (int)(this.contentLeftPos + 282), (int)(this.f_97736_ + 188), (int)-16777216);
        CustomSkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.f_97736_ + 103), (int)(this.contentLeftPos + 281), (int)(this.f_97736_ + 187), (int)-5592406);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6375_(mouseX, mouseY, button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

