/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.ScreenHelper;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.menu.configuration.skin.PlayerSkinConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class PlayerSkinConfigurationScreen
extends SkinConfigurationScreen<PlayerSkinConfigurationMenu> {
    private Button clearTextureSettingsButton = null;
    private Button skinNextButton = null;
    private Button skinNextPageButton = null;
    private Button skinPreviousButton = null;
    private Button skinPreviousPageButton = null;
    private List<Button> skinButtons = new ArrayList<Button>();
    protected Button addTextureSettingsButton = null;
    protected EditBox textureSkinLocationBox;
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_DELAY = 20;
    private int skinStartIndex = 0;
    private int maxSkinsPerPage = 5;
    private String formerTextureSkinLocation = "";
    private boolean canTextureSkinLocationChange = true;
    protected static int nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond();
    protected int numOfSkins = 0;
    protected int lastNumOfSkins = 0;

    public PlayerSkinConfigurationScreen(PlayerSkinConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void renderSkins(PoseStack poseStack) {
        if (this.entity == null) {
            return;
        }
        int positionTop = 119;
        int skinPosition = 0;
        this.skinButtons = new ArrayList<Button>();
        Set<UUID> textures = PlayerTextureManager.getPlayerTextureCacheKeys(this.skinModel);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.f_97735_ + 32 + skinPosition * this.skinPreviewWidth;
            int top = this.f_97736_ + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(poseStack, left, top, this.skinModel, textureKey);
            float topNamePos = ((float)top - 76.0f) / 0.7f;
            float leftNamePos = ((float)left - 21.0f) / 0.7f;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 100.0f);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(textureKey.toString(), 11);
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237113_((String)variantName), leftNamePos, topNamePos, 43520);
            poseStack.m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(PoseStack poseStack, int x, int y, SkinModel skinModel, UUID textureUUID) {
        TextureModelKey textureModelKey = new TextureModelKey(textureUUID, skinModel);
        SkinType skinType = PlayerTextureManager.getPlayerTextureSkinType(textureModelKey);
        int skinButtonLeft = x - 24;
        int skinButtonTop = y - 81;
        int skinButtonHeight = 84;
        ImageButton skinButton = new ImageButton(skinButtonLeft, skinButtonTop, this.skinPreviewWidth, skinButtonHeight, 0, -84, 84, Constants.TEXTURE_CONFIGURATION, button -> {
            String skinURL = PlayerTextureManager.getPlayerTextureSkinURL(textureModelKey);
            NetworkMessage.skinChange(this.uuid, "", skinURL, textureUUID, skinType);
        });
        Optional skinUUID = this.entity.getSkinUUID();
        if (skinUUID.isPresent() && ((UUID)skinUUID.get()).equals(textureUUID)) {
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_CONFIGURATION);
            PlayerSkinConfigurationScreen.m_93228_((PoseStack)poseStack, (int)skinButtonLeft, (int)skinButtonTop, (int)0, (int)skinButtonHeight, (int)this.skinPreviewWidth, (int)skinButtonHeight);
            poseStack.m_85849_();
        }
        ScreenHelper.renderEntityPlayerSkin(x, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.entity, textureUUID, skinType);
        this.skinButtons.add((Button)skinButton);
    }

    private void clearTextureSkinLocation() {
        if (!this.textureSkinLocationBox.m_94155_().isEmpty()) {
            this.textureSkinLocationBox.m_94144_("");
        }
    }

    private void addTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.m_94155_();
        if (textureSkinLocationValue != null && !textureSkinLocationValue.equals(this.formerTextureSkinLocation) && (textureSkinLocationValue.isEmpty() || PlayersUtils.isValidPlayerName(textureSkinLocationValue) || PlayersUtils.isValidUrl(textureSkinLocationValue))) {
            if (PlayersUtils.isValidPlayerName(textureSkinLocationValue)) {
                log.debug("Settings player user texture to {}", (Object)textureSkinLocationValue);
                NetworkMessage.skinChange(this.uuid, textureSkinLocationValue, SkinType.PLAYER_SKIN);
            } else if (PlayersUtils.isValidUrl(textureSkinLocationValue)) {
                log.debug("Setting remote user texture to {}", (Object)textureSkinLocationValue);
                NetworkMessage.skinChange(this.uuid, textureSkinLocationValue, SkinType.INSECURE_REMOTE_URL);
            }
            this.addTextureSettingsButton.f_93623_ = false;
            this.formerTextureSkinLocation = textureSkinLocationValue;
            PlayerSkinConfigurationScreen.updateNextTextureSkinLocationChange();
        }
    }

    private static void updateNextTextureSkinLocationChange() {
        nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond() + 20;
    }

    private void validateTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.m_94155_();
        if (!this.canTextureSkinLocationChange && textureSkinLocationValue != null) {
            this.addTextureSettingsButton.f_93623_ = false;
            this.clearTextureSettingsButton.f_93623_ = true;
            return;
        }
        switch (this.skinModel) {
            case HUMANOID: 
            case HUMANOID_SLIM: {
                this.addTextureSettingsButton.f_93623_ = textureSkinLocationValue != null && !textureSkinLocationValue.isEmpty() && (PlayersUtils.isValidPlayerName(textureSkinLocationValue) || PlayersUtils.isValidUrl(textureSkinLocationValue));
                break;
            }
            default: {
                this.addTextureSettingsButton.f_93623_ = PlayersUtils.isValidUrl(textureSkinLocationValue);
            }
        }
        this.clearTextureSettingsButton.f_93623_ = textureSkinLocationValue != null && !textureSkinLocationValue.isEmpty();
    }

    private void checkSkinButtonState() {
        boolean skinButtonShouldBeVisible;
        this.skinPreviousButton.f_93624_ = skinButtonShouldBeVisible = this.numOfSkins > this.maxSkinsPerPage;
        this.skinNextButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinPreviousPageButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinNextPageButton.f_93624_ = skinButtonShouldBeVisible;
        this.skinPreviousButton.f_93623_ = this.skinStartIndex > 0;
        this.skinNextButton.f_93623_ = this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins;
        this.skinPreviousPageButton.f_93623_ = this.skinStartIndex - this.maxSkinsPerPage > 0;
        this.skinNextPageButton.f_93623_ = this.skinStartIndex + 1 + this.maxSkinsPerPage < this.numOfSkins;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.playerSkinButton.f_93623_ = false;
        this.numOfSkins = PlayerTextureManager.getPlayerTextureCacheKeys(this.skinModel).size();
        this.textureSkinLocationBox = new EditBox(this.f_96547_, this.contentLeftPos, this.f_97736_ + 60, 160, 20, (Component)Component.m_237115_((String)"Skin Location"));
        this.textureSkinLocationBox.m_94199_(255);
        this.textureSkinLocationBox.m_94144_("");
        this.textureSkinLocationBox.m_94151_(consumer -> this.validateTextureSkinLocation());
        this.m_142416_((GuiEventListener)this.textureSkinLocationBox);
        this.addTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)PlayerSkinConfigurationScreen.menuButton(this.textureSkinLocationBox.m_252754_() + this.textureSkinLocationBox.m_5711_() + 2, this.f_97736_ + 60, 65, "add", onPress -> this.addTextureSkinLocation()));
        this.addTextureSettingsButton.f_93623_ = false;
        this.clearTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)PlayerSkinConfigurationScreen.menuButton(this.addTextureSettingsButton.m_252754_() + this.addTextureSettingsButton.m_5711_() + 1, this.f_97736_ + 60, 55, "clear", onPress -> this.clearTextureSkinLocation()));
        int skinButtonTop = this.f_97736_ + 187;
        int skinButtonLeft = this.contentLeftPos;
        int skinButtonRight = this.rightPos - 31;
        this.skinPreviousPageButton = (Button)this.m_142416_((GuiEventListener)PlayerSkinConfigurationScreen.menuButton(skinButtonLeft, skinButtonTop, 20, (Component)Component.m_237113_((String)"<<"), onPress -> {
            this.skinStartIndex = this.skinStartIndex - this.maxSkinsPerPage > 0 ? (this.skinStartIndex -= this.maxSkinsPerPage) : 0;
            this.checkSkinButtonState();
        }));
        this.skinPreviousButton = (Button)this.m_142416_((GuiEventListener)PlayerSkinConfigurationScreen.menuButton(skinButtonLeft + 20, skinButtonTop, 20, (Component)Component.m_237113_((String)"<"), onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinButtonState();
        }));
        this.skinNextPageButton = (Button)this.m_142416_((GuiEventListener)PlayerSkinConfigurationScreen.menuButton(skinButtonRight, skinButtonTop, 20, (Component)Component.m_237113_((String)">>"), onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinButtonState();
        }));
        this.skinNextButton = (Button)this.m_142416_((GuiEventListener)PlayerSkinConfigurationScreen.menuButton(skinButtonRight - 20, skinButtonTop, 20, (Component)Component.m_237113_((String)">"), onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinButtonState();
        }));
        this.checkSkinButtonState();
    }

    @Override
    public void m_86412_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_86412_(poseStack, x, y, partialTicks);
        if (this.isPlayerSkinModel) {
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)"text.easy_npc.config.use_a_player_name"), (float)this.contentLeftPos, (float)this.f_97736_ + 50.0f, 0x404040);
        } else {
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)"text.easy_npc.config.use_a_skin_url"), (float)this.contentLeftPos, (float)this.f_97736_ + 50.0f, 0x404040);
        }
        boolean bl = this.canTextureSkinLocationChange = Instant.now().getEpochSecond() >= (long)nextTextureSkinLocationChange;
        if (!this.canTextureSkinLocationChange) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_CONFIGURATION);
            poseStack.m_252880_(0.0f, 0.0f, 100.0f);
            PlayerSkinConfigurationScreen.m_93228_((PoseStack)poseStack, (int)(this.f_97735_ + 155), (int)(this.f_97736_ + 65), (int)82, (int)1, (int)8, (int)10);
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)"text.easy_npc.config.processing_skin"), (float)this.f_97735_ + 55.0f, (float)this.f_97736_ + 88.0f, 0x404040);
        }
        this.renderSkins(poseStack);
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_86412_(poseStack, x, y, partialTicks);
            }
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        PlayerSkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(this.f_97736_ + 102), (int)(this.contentLeftPos + 282), (int)(this.f_97736_ + 188), (int)-16777216);
        PlayerSkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.f_97736_ + 103), (int)(this.contentLeftPos + 281), (int)(this.f_97736_ + 187), (int)-5592406);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6375_(mouseX, mouseY, button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

