/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomDataHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    protected CustomDataHandler() {
    }

    public static void prepare() {
        log.info("{} custom data ...", (Object)"\ud83d\udde3 Register Easy NPC");
        log.info("{} custom data folder at {} ...", (Object)"\ud83d\udde3 Create Easy NPC", (Object)CustomDataHandler.getCustomDataFolder());
    }

    public static Path getCustomDataFolder() {
        try {
            return FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("easy_npc"), (String)"easy_npc");
        }
        catch (Exception exception) {
            log.error("There was an error, creating the custom data folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getOrCreateCustomDataFolder(String dataLabel) {
        Path customDataFolder = CustomDataHandler.getCustomDataFolder();
        if (customDataFolder == null) {
            return null;
        }
        try {
            return FileUtils.getOrCreateDirectory((Path)customDataFolder.resolve(dataLabel), (String)dataLabel);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the custom data folder:", (Throwable)exception);
            return null;
        }
    }

    public static void copyResourceFile(ResourceLocation resourceLocation, File targetFile) {
        block15: {
            if (resourceLocation != null) {
                try {
                    Optional resources = Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation);
                    if (!resources.isPresent()) break block15;
                    try (InputStream inputStream = ((Resource)resources.get()).m_215507_();
                         FileOutputStream outputStream = new FileOutputStream(targetFile);){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = inputStream.read(buffer)) > 0) {
                            ((OutputStream)outputStream).write(buffer, 0, length);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Failed to load resource {}!", (Object)resourceLocation, (Object)e);
                }
            }
        }
    }
}

