/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.config.CommonConfig;
import de.markusbordihn.easynpc.data.WorldPresetData;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.menu.DialogMenu;
import de.markusbordihn.easynpc.menu.configuration.action.BasicActionConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.action.DialogActionConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.dialog.BasicDialogConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.dialog.NoneDialogConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.dialog.YesNoDialogConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.main.MainConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.pose.AdvancedPoseConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.pose.CustomPoseConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.pose.DefaultPoseConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.position.DefaultPositionConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.CustomExportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.CustomImportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.DefaultImportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.WorldExportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.WorldImportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.rotation.DefaultRotationConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.scaling.ScalingConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.skin.CustomSkinConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.skin.DefaultSkinConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.skin.PlayerSkinConfigurationMenu;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCEntityMenu {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;

    protected EasyNPCEntityMenu() {
    }

    public static void openDialogMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        UUID uuid = entity.m_20148_();
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DialogMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
    }

    public static void openEquipmentConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.equipmentConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.equipmentConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.equipmentConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)EquipmentConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openBasicActionConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.basicActionConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.basicActionConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.basicActionConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)BasicActionConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDialogActionConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.dialogActionConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.dialogActionConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.dialogActionConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DialogActionConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openBasicDialogConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.basicDialogConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.basicDialogConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.basicDialogConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)BasicDialogConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openYesNoDialogConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.yesNoDialogConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.yesNoDialogConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.yesNoDialogConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)YesNoDialogConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openMainConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.mainConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.mainConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.mainConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)MainConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openAdvancedPoseConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.advancedPoseConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.advancedPoseConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.advancedPoseConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)AdvancedPoseConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openCustomPoseConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.customPoseConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.customPoseConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.customPoseConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomPoseConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultPoseConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.defaultPoseConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.defaultPoseConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.defaultPoseConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultPoseConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultPositionConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.defaultPositionConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.defaultPositionConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.defaultPositionConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultPositionConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultRotationConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.defaultRotationConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.defaultRotationConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.defaultRotationConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultRotationConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openCustomSkinConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.customSkinConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.customSkinConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.customSkinConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomSkinConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultSkinConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.defaultSkinConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.defaultSkinConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.defaultSkinConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultSkinConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openNoneDialogConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.noneDialogConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.noneDialogConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.noneDialogConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)NoneDialogConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openPlayerSkinConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.playerSkinConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.playerSkinConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.playerSkinConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)PlayerSkinConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openScalingConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity entity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, entity, (Boolean)EasyNPCEntityMenu.COMMON.scalingConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.scalingConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.scalingConfigurationPermissionLevel.get())) {
            UUID uuid = entity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)ScalingConfigurationMenu.getMenuProvider(uuid, (Entity)entity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openCustomPresetExportConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity easyNPCEntity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, easyNPCEntity, (Boolean)EasyNPCEntityMenu.COMMON.customExportPresetConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.customExportPresetConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.customExportPresetConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPCEntity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomExportPresetConfigurationMenu.getMenuProvider(uuid, (Entity)easyNPCEntity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openWorldPresetExportConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity easyNPCEntity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, easyNPCEntity, (Boolean)EasyNPCEntityMenu.COMMON.worldExportPresetConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.worldExportPresetConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.worldExportPresetConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPCEntity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)WorldExportPresetConfigurationMenu.getMenuProvider(uuid, (Entity)easyNPCEntity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultPresetImportConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity easyNPCEntity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, easyNPCEntity, (Boolean)EasyNPCEntityMenu.COMMON.defaultImportPresetConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.defaultImportPresetConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.defaultImportPresetConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPCEntity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultImportPresetConfigurationMenu.getMenuProvider(uuid, (Entity)easyNPCEntity), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openServerPresetImportConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity easyNPCEntity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, easyNPCEntity, (Boolean)EasyNPCEntityMenu.COMMON.worldImportPresetConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.worldImportPresetConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.worldImportPresetConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPCEntity.m_20148_();
            List<ResourceLocation> worldPresets = WorldPresetData.getPresetFilePathResourceLocations().toList();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)WorldImportPresetConfigurationMenu.getMenuProvider(uuid, (Entity)easyNPCEntity, worldPresets), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130130_(worldPresets.size());
                for (ResourceLocation worldPreset : worldPresets) {
                    buffer.m_130085_(worldPreset);
                }
            });
        }
    }

    public static void openCustomPresetImportConfigurationMenu(ServerPlayer serverPlayer, EasyNPCEntity easyNPCEntity) {
        if (EasyNPCEntityMenu.hasPermissions(serverPlayer, easyNPCEntity, (Boolean)EasyNPCEntityMenu.COMMON.customImportPresetConfigurationEnabled.get(), (Boolean)EasyNPCEntityMenu.COMMON.customImportPresetConfigurationAllowInCreative.get(), (Integer)EasyNPCEntityMenu.COMMON.customImportPresetConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPCEntity.m_20148_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomImportPresetConfigurationMenu.getMenuProvider(uuid, (Entity)easyNPCEntity), buffer -> buffer.m_130077_(uuid));
        }
    }

    private static boolean hasPermissions(ServerPlayer serverPlayer, EasyNPCEntity entity, Boolean enabled, Boolean allowInCreative, int permissionLevel) {
        if (Boolean.FALSE.equals(enabled) || serverPlayer == null) {
            return false;
        }
        if (Boolean.TRUE.equals(allowInCreative) && serverPlayer.m_7500_()) {
            return true;
        }
        if (!entity.hasOwner() || !entity.isOwner(serverPlayer)) {
            return false;
        }
        return serverPlayer.m_20310_(permissionLevel);
    }
}

