/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class EntityManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static ConcurrentHashMap<UUID, Entity> entityMap = new ConcurrentHashMap();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EasyNPCEntity) {
            EasyNPCEntity easyNPCEntity = (EasyNPCEntity)entity;
            log.debug("[Add] EASY NPC entity {}: {}", (Object)entity.m_20148_(), (Object)easyNPCEntity);
            entityMap.put(entity.m_20148_(), entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityLeaveWorldEvent(EntityLeaveLevelEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EasyNPCEntity) {
            EasyNPCEntity easyNPCEntity = (EasyNPCEntity)entity;
            if (entityMap.containsKey(entity.m_20148_())) {
                log.debug("[Remove] EASY NPC entity {}: {}", (Object)entity.m_20148_(), (Object)easyNPCEntity);
                entityMap.remove(entity.m_20148_());
            }
        }
    }

    public static Entity getEntityByUUID(UUID uuid) {
        return entityMap.getOrDefault(uuid, null);
    }

    public static ConcurrentMap<UUID, Entity> getEntityMap() {
        return entityMap;
    }

    public static Map<UUID, Entity> getEntityMapByOwner(ServerPlayer serverPlayer) {
        return serverPlayer != null ? EntityManager.getEntityMapByOwner(serverPlayer.m_20148_()) : null;
    }

    public static Map<UUID, Entity> getEntityMapByOwner(UUID ownerUUID) {
        HashMap<UUID, Entity> result = new HashMap<UUID, Entity>();
        for (Map.Entry<UUID, Entity> entry : entityMap.entrySet()) {
            EasyNPCEntity easyNPCEntity;
            Entity entity = entry.getValue();
            if (!(entity instanceof EasyNPCEntity) || !(easyNPCEntity = (EasyNPCEntity)entity).isOwner(ownerUUID)) continue;
            result.put(entry.getKey(), entity);
        }
        return result;
    }

    public static Stream<String> getUUIDStrings() {
        return entityMap.keySet().stream().map(UUID::toString);
    }

    public static Stream<String> getUUIDStringsByOwner(ServerPlayer serverPlayer) {
        Map<UUID, Entity> entityMapByOwner = EntityManager.getEntityMapByOwner(serverPlayer);
        return entityMapByOwner != null ? entityMapByOwner.keySet().stream().map(UUID::toString) : null;
    }

    public static EasyNPCEntity getEasyNPCEntityByUUID(UUID uuid, ServerPlayer serverPlayer) {
        ServerLevel serverLevel = serverPlayer.m_9236_();
        Entity entity = serverLevel.m_8791_(uuid);
        if (entity instanceof EasyNPCEntity) {
            EasyNPCEntity easyNPCEntity = (EasyNPCEntity)entity;
            return easyNPCEntity;
        }
        return EntityManager.getEasyNPCEntityByUUID(uuid);
    }

    public static EasyNPCEntity getEasyNPCEntityByUUID(UUID uuid) {
        Entity entity = entityMap.getOrDefault(uuid, null);
        if (entity instanceof EasyNPCEntity) {
            EasyNPCEntity easyNPCEntity = (EasyNPCEntity)entity;
            return easyNPCEntity;
        }
        return null;
    }

    public static boolean hasAccess(UUID uuid, ServerPlayer serverPlayer) {
        if (uuid == null || serverPlayer == null) {
            return false;
        }
        return EntityManager.hasAccess(serverPlayer.m_9236_().m_8791_(uuid), serverPlayer);
    }

    public static boolean hasAccess(Entity entity, ServerPlayer serverPlayer) {
        if (entity instanceof EasyNPCEntity) {
            EasyNPCEntity easyNPCEntity = (EasyNPCEntity)entity;
            return EntityManager.hasAccess(easyNPCEntity, serverPlayer);
        }
        return false;
    }

    public static boolean hasAccess(EasyNPCEntity entity, ServerPlayer serverPlayer) {
        if (serverPlayer.m_7500_()) {
            return true;
        }
        if (entity.hasOwner()) {
            UUID uuid = entity.getOwnerUUID();
            return uuid != null && uuid.equals(serverPlayer.m_20148_());
        }
        return false;
    }
}

