/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.data.action.ActionData;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.Profession;
import de.markusbordihn.easynpc.network.message.MessageActionChange;
import de.markusbordihn.easynpc.network.message.MessageDialogTypeChange;
import de.markusbordihn.easynpc.network.message.MessageModelLockRotationChange;
import de.markusbordihn.easynpc.network.message.MessageModelPoseChange;
import de.markusbordihn.easynpc.network.message.MessageModelPositionChange;
import de.markusbordihn.easynpc.network.message.MessageModelVisibilityChange;
import de.markusbordihn.easynpc.network.message.MessageNameChange;
import de.markusbordihn.easynpc.network.message.MessageOpenConfiguration;
import de.markusbordihn.easynpc.network.message.MessagePoseChange;
import de.markusbordihn.easynpc.network.message.MessagePositionChange;
import de.markusbordihn.easynpc.network.message.MessagePresetExport;
import de.markusbordihn.easynpc.network.message.MessagePresetExportClient;
import de.markusbordihn.easynpc.network.message.MessagePresetExportWorld;
import de.markusbordihn.easynpc.network.message.MessagePresetImport;
import de.markusbordihn.easynpc.network.message.MessagePresetImportWorld;
import de.markusbordihn.easynpc.network.message.MessageProfessionChange;
import de.markusbordihn.easynpc.network.message.MessageRemoveNPC;
import de.markusbordihn.easynpc.network.message.MessageRotationChange;
import de.markusbordihn.easynpc.network.message.MessageSaveBasicDialog;
import de.markusbordihn.easynpc.network.message.MessageSaveYesNoDialog;
import de.markusbordihn.easynpc.network.message.MessageScaleChange;
import de.markusbordihn.easynpc.network.message.MessageSkinChange;
import de.markusbordihn.easynpc.network.message.MessageTriggerAction;
import de.markusbordihn.easynpc.network.message.MessageVariantChange;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class NetworkHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String PROTOCOL_VERSION = "10";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("easy_npc", "network"), () -> "10", "10"::equals, "10"::equals);
    private static int id = 0;

    public static void registerNetworkHandler(FMLCommonSetupEvent event) {
        log.info("{} Network Handler for {} with version {} ...", (Object)"\ud83d\udde3 Register Easy NPC", (Object)INSTANCE, (Object)PROTOCOL_VERSION);
        event.enqueueWork(() -> {
            INSTANCE.registerMessage(id++, MessageActionChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                ActionData.encode(message, buffer);
            }, buffer -> new MessageActionChange(buffer.m_130259_(), ActionData.decode(buffer)), MessageActionChange::handle);
            INSTANCE.registerMessage(id++, MessageTriggerAction.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getActionType());
            }, buffer -> new MessageTriggerAction(buffer.m_130259_(), buffer.m_130277_()), MessageTriggerAction::handle);
            INSTANCE.registerMessage(id++, MessageNameChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getName());
            }, buffer -> new MessageNameChange(buffer.m_130259_(), buffer.m_130277_()), MessageNameChange::handle);
            INSTANCE.registerMessage(id++, MessageOpenConfiguration.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getDialogName());
            }, buffer -> new MessageOpenConfiguration(buffer.m_130259_(), buffer.m_130277_()), MessageOpenConfiguration::handle);
            INSTANCE.registerMessage(id++, MessageDialogTypeChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130068_((Enum)message.getDialogType());
            }, buffer -> new MessageDialogTypeChange(buffer.m_130259_(), (DialogType)buffer.m_130066_(DialogType.class)), MessageDialogTypeChange::handle);
            INSTANCE.registerMessage(id++, MessageSaveBasicDialog.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getDialog());
            }, buffer -> new MessageSaveBasicDialog(buffer.m_130259_(), buffer.m_130277_()), MessageSaveBasicDialog::handle);
            INSTANCE.registerMessage(id++, MessageSaveYesNoDialog.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getDialog());
                buffer.m_130070_(message.getYesDialog());
                buffer.m_130070_(message.getNoDialog());
                buffer.m_130070_(message.getYesButtonText());
                buffer.m_130070_(message.getNoButtonText());
            }, buffer -> new MessageSaveYesNoDialog(buffer.m_130259_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_()), MessageSaveYesNoDialog::handle);
            INSTANCE.registerMessage(id++, MessageModelLockRotationChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.writeBoolean(message.getLockRotation());
            }, buffer -> new MessageModelLockRotationChange(buffer.m_130259_(), buffer.readBoolean()), MessageModelLockRotationChange::handle);
            INSTANCE.registerMessage(id++, MessageModelPoseChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130068_((Enum)message.getModelPose());
            }, buffer -> new MessageModelPoseChange(buffer.m_130259_(), (ModelPose)buffer.m_130066_(ModelPose.class)), MessageModelPoseChange::handle);
            INSTANCE.registerMessage(id++, MessageModelPositionChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130068_((Enum)message.getModelPart());
                buffer.writeFloat(message.getX());
                buffer.writeFloat(message.getY());
                buffer.writeFloat(message.getZ());
            }, buffer -> new MessageModelPositionChange(buffer.m_130259_(), (ModelPart)buffer.m_130066_(ModelPart.class), buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), MessageModelPositionChange::handle);
            INSTANCE.registerMessage(id++, MessageModelVisibilityChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130068_((Enum)message.getModelPart());
                buffer.writeBoolean(message.isVisible());
            }, buffer -> new MessageModelVisibilityChange(buffer.m_130259_(), (ModelPart)buffer.m_130066_(ModelPart.class), buffer.readBoolean()), MessageModelVisibilityChange::handle);
            INSTANCE.registerMessage(id++, MessagePoseChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130068_((Enum)message.getPose());
            }, buffer -> new MessagePoseChange(buffer.m_130259_(), (Pose)buffer.m_130066_(Pose.class)), MessagePoseChange::handle);
            INSTANCE.registerMessage(id++, MessagePositionChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.writeFloat(message.getX());
                buffer.writeFloat(message.getY());
                buffer.writeFloat(message.getZ());
            }, buffer -> new MessagePositionChange(buffer.m_130259_(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), MessagePositionChange::handle);
            INSTANCE.registerMessage(id++, MessageProfessionChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130068_((Enum)message.getProfession());
            }, buffer -> new MessageProfessionChange(buffer.m_130259_(), (Profession)buffer.m_130066_(Profession.class)), MessageProfessionChange::handle);
            INSTANCE.registerMessage(id++, MessageRotationChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130068_((Enum)message.getModelPart());
                buffer.writeFloat(message.getX());
                buffer.writeFloat(message.getY());
                buffer.writeFloat(message.getZ());
            }, buffer -> new MessageRotationChange(buffer.m_130259_(), (ModelPart)buffer.m_130066_(ModelPart.class), buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), MessageRotationChange::handle);
            INSTANCE.registerMessage(id++, MessageScaleChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getScaleAxis());
                buffer.writeFloat(message.getScale().floatValue());
            }, buffer -> new MessageScaleChange(buffer.m_130259_(), buffer.m_130277_(), Float.valueOf(buffer.readFloat())), MessageScaleChange::handle);
            INSTANCE.registerMessage(id++, MessageSkinChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getSkin());
                buffer.m_130070_(message.getSkinURL());
                buffer.m_130077_(message.getSkinUUID());
                buffer.m_130070_(message.getSkinType());
            }, buffer -> new MessageSkinChange(buffer.m_130259_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130259_(), buffer.m_130277_()), MessageSkinChange::handle);
            INSTANCE.registerMessage(id++, MessageVariantChange.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getVariant());
            }, buffer -> new MessageVariantChange(buffer.m_130259_(), buffer.m_130277_()), MessageVariantChange::handle);
            INSTANCE.registerMessage(id++, MessageRemoveNPC.class, (message, buffer) -> buffer.m_130077_(message.getUUID()), buffer -> new MessageRemoveNPC(buffer.m_130259_()), MessageRemoveNPC::handle);
            INSTANCE.registerMessage(id++, MessagePresetExport.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getName());
            }, buffer -> new MessagePresetExport(buffer.m_130259_(), buffer.m_130277_()), MessagePresetExport::handle);
            INSTANCE.registerMessage(id++, MessagePresetExportClient.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getName());
                buffer.m_130070_(message.getSkinModel());
                buffer.m_130070_(message.getFileName());
                buffer.m_130079_(message.getData());
            }, buffer -> new MessagePresetExportClient(buffer.m_130259_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130260_()), MessagePresetExportClient::handle);
            INSTANCE.registerMessage(id++, MessagePresetExportWorld.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130070_(message.getName());
            }, buffer -> new MessagePresetExportWorld(buffer.m_130259_(), buffer.m_130277_()), MessagePresetExportWorld::handle);
            INSTANCE.registerMessage(id++, MessagePresetImport.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130079_(message.getCompoundTag());
            }, buffer -> new MessagePresetImport(buffer.m_130259_(), buffer.m_130260_()), MessagePresetImport::handle);
            INSTANCE.registerMessage(id++, MessagePresetImportWorld.class, (message, buffer) -> {
                buffer.m_130077_(message.getUUID());
                buffer.m_130085_(message.getResourceLocation());
            }, buffer -> new MessagePresetImportWorld(buffer.m_130259_(), buffer.m_130281_()), MessagePresetImportWorld::handle);
        });
    }

    public static <M> void sendToServer(M message) {
        try {
            INSTANCE.sendToServer(message);
        }
        catch (Exception e) {
            log.error("Failed to send {} to server, got error: {}", message, (Object)e.getMessage());
        }
    }

    public static <M> void sendToPlayer(M message, ServerPlayer serverPlayer) {
        try {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), message);
        }
        catch (Exception e) {
            log.error("Failed to send {} to player {}, got error: {}", message, (Object)serverPlayer.m_7755_().getString(), (Object)e.getMessage());
        }
    }
}

