/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageModelPoseChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final ModelPose modelPose;

    public MessageModelPoseChange(UUID uuid, ModelPose modelPose) {
        this.uuid = uuid;
        this.modelPose = modelPose;
    }

    public ModelPose getModelPose() {
        return this.modelPose;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageModelPoseChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelPoseChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelPoseChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ModelPose modelPose = message.getModelPose();
        if (modelPose == null) {
            log.error("Invalid modelPose {} for {} from {}", (Object)modelPose, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change modelPose {} for {} from {}", (Object)modelPose, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.setModelPose(modelPose);
        easyNPCEntity.m_20124_(Pose.STANDING);
    }
}

