/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageNameChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String name;

    public MessageNameChange(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageNameChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageNameChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageNameChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String name = message.getName();
        if (name == null || name.isEmpty()) {
            log.error("Invalid name {} for {} from {}", (Object)name, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change name {} for {} from {}", (Object)name, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.m_6593_((Component)Component.m_237113_((String)name));
    }
}

