/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EasyNPCEntityMenu;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationType;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageOpenConfiguration {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String dialogName;

    public MessageOpenConfiguration(UUID uuid, String dialogName) {
        this.uuid = uuid;
        this.dialogName = dialogName;
    }

    public String getDialogName() {
        return this.dialogName;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageOpenConfiguration message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageOpenConfiguration.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageOpenConfiguration message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String dialogName = message.getDialogName();
        if (dialogName == null || dialogName.isEmpty()) {
            log.error("Invalid dialog name {} for {} from {}", (Object)dialogName, (Object)message, (Object)serverPlayer);
            return;
        }
        ConfigurationType configurationType = ConfigurationType.valueOf(dialogName);
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        switch (configurationType) {
            case ADVANCED_POSE: {
                EasyNPCEntityMenu.openAdvancedPoseConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case BASIC_ACTION: {
                EasyNPCEntityMenu.openBasicActionConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case DIALOG_ACTION: {
                EasyNPCEntityMenu.openDialogActionConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case BASIC_DIALOG: {
                EasyNPCEntityMenu.openBasicDialogConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case CUSTOM_SKIN: {
                EasyNPCEntityMenu.openCustomSkinConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case DEFAULT_SKIN: {
                EasyNPCEntityMenu.openDefaultSkinConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case EQUIPMENT: {
                EasyNPCEntityMenu.openEquipmentConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case MAIN: {
                EasyNPCEntityMenu.openMainConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case DEFAULT_POSE: {
                EasyNPCEntityMenu.openDefaultPoseConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case CUSTOM_POSE: {
                EasyNPCEntityMenu.openCustomPoseConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case DEFAULT_POSITION: {
                EasyNPCEntityMenu.openDefaultPositionConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case DEFAULT_ROTATION: {
                EasyNPCEntityMenu.openDefaultRotationConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case NONE_DIALOG: {
                EasyNPCEntityMenu.openNoneDialogConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case PLAYER_SKIN: {
                EasyNPCEntityMenu.openPlayerSkinConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case SCALING: {
                EasyNPCEntityMenu.openScalingConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case YES_NO_DIALOG: {
                EasyNPCEntityMenu.openYesNoDialogConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case CUSTOM_PRESET_EXPORT: {
                EasyNPCEntityMenu.openCustomPresetExportConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case WORLD_PRESET_EXPORT: {
                EasyNPCEntityMenu.openWorldPresetExportConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case DEFAULT_PRESET_IMPORT: {
                EasyNPCEntityMenu.openDefaultPresetImportConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case WORLD_PRESET_IMPORT: {
                EasyNPCEntityMenu.openServerPresetImportConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            case CUSTOM_PRESET_IMPORT: {
                EasyNPCEntityMenu.openCustomPresetImportConfigurationMenu(serverPlayer, easyNPCEntity);
                break;
            }
            default: {
                log.debug("Unknown dialog {} for {} from {}", (Object)dialogName, (Object)easyNPCEntity, (Object)serverPlayer);
            }
        }
    }
}

