/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageVariantChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String variant;

    public MessageVariantChange(UUID uuid, String variant) {
        this.uuid = uuid;
        this.variant = variant;
    }

    public String getVariant() {
        return this.variant;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageVariantChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageVariantChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageVariantChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String variant = message.getVariant();
        if (variant == null || variant.isEmpty()) {
            log.error("Invalid variant {} for {} from {}", (Object)variant, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change variant {} for {} from {}", (Object)variant, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.setVariant(variant);
    }
}

