/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.client.model;

import bagu_chan.bagus_lib.client.layer.IArmor;
import baguchan.enchantwithmob.client.animation.EnchanterAnimation;
import baguchan.enchantwithmob.entity.EnchanterEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnchanterModel<T extends EnchanterEntity>
extends HierarchicalModel<T>
implements IArmor {
    private final ModelPart realRoot;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart cape;
    private final ModelPart illagerArms;
    private final ModelPart bipedArms;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart armorLeftLeg;
    private final ModelPart armorRightLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightHand;
    private final ModelPart leftHand;
    private final ModelPart illagerRightArm;
    private final ModelPart illagerLeftArm;
    private final ModelPart armorBipedLeftArm;
    private final ModelPart armorBipedRightArm;

    public EnchanterModel(ModelPart root) {
        this.realRoot = root;
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("bipedBody");
        this.head = this.body.m_171324_("bipedHeadBaseRotator");
        this.cape = this.body.m_171324_("bipedCape");
        this.illagerArms = this.body.m_171324_("illagerArms");
        this.illagerRightArm = this.illagerArms.m_171324_("armorIllagerLeftArm");
        this.illagerLeftArm = this.illagerArms.m_171324_("armorIllagerRightArm");
        this.leftLeg = this.root.m_171324_("bipedLegs").m_171324_("bipedLegLeft");
        this.rightLeg = this.root.m_171324_("bipedLegs").m_171324_("bipedLegRight");
        this.armorRightLeg = this.rightLeg.m_171324_("armorBipedRightLeg");
        this.armorLeftLeg = this.leftLeg.m_171324_("armorBipedLeftLeg");
        this.bipedArms = this.body.m_171324_("bipedArms");
        this.leftArm = this.bipedArms.m_171324_("bipedArmLeft");
        this.rightArm = this.bipedArms.m_171324_("bipedArmRight");
        this.leftHand = this.leftArm.m_171324_("bipedHandLeft");
        this.rightHand = this.rightArm.m_171324_("bipedHandRight");
        this.armorBipedLeftArm = this.leftArm.m_171324_("armorBipedLeftArm");
        this.armorBipedRightArm = this.rightArm.m_171324_("armorBipedRightArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition bipedLegs = root.m_171599_("bipedLegs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition bipedLegLeft = bipedLegs.m_171599_("bipedLegLeft", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition armorBipedLeftLeg = bipedLegLeft.m_171599_("armorBipedLeftLeg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition armorBipedLeftFoot = bipedLegLeft.m_171599_("armorBipedLeftFoot", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bipedLegRight = bipedLegs.m_171599_("bipedLegRight", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition armorBipedRightLeg = bipedLegRight.m_171599_("armorBipedRightLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition armorBipedRightFoot = bipedLegRight.m_171599_("armorBipedRightFoot", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bipedBody = root.m_171599_("bipedBody", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -10.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, -10.0f, -3.0f, 8.0f, 19.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition bipedArms = bipedBody.m_171599_("bipedArms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition bipedArmLeft = bipedArms.m_171599_("bipedArmLeft", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)0.0f));
        PartDefinition bipedHandLeft = bipedArmLeft.m_171599_("bipedHandLeft", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)11.0f, (float)0.0f));
        PartDefinition armorBipedLeftArm = bipedArmLeft.m_171599_("armorBipedLeftArm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bipedArmRight = bipedArms.m_171599_("bipedArmRight", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)0.0f));
        PartDefinition bipedHandRight = bipedArmRight.m_171599_("bipedHandRight", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)11.0f, (float)0.0f));
        PartDefinition armorBipedRightArm = bipedArmRight.m_171599_("armorBipedRightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition illagerArms = bipedBody.m_171599_("illagerArms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(4.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171480_().m_171488_(-8.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(40, 38).m_171488_(-4.0f, 4.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.5f, (float)0.3f, (float)-0.7505f, (float)0.0f, (float)0.0f));
        PartDefinition armorIllagerLeftArm = illagerArms.m_171599_("armorIllagerLeftArm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -1.5f, -2.05f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)0.0f));
        PartDefinition armorIllagerRightArm = illagerArms.m_171599_("armorIllagerRightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -1.5f, -2.05f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)0.0f));
        PartDefinition bipedCape = bipedBody.m_171599_("bipedCape", CubeListBuilder.m_171558_().m_171514_(0, 64).m_171488_(-6.0f, 0.0f, 0.0f, 12.0f, 23.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition bipedPotionSlot = bipedBody.m_171599_("bipedPotionSlot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)1.0f, (float)0.0f));
        PartDefinition armorBipedBody = bipedBody.m_171599_("armorBipedBody", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition bipedHeadBaseRotator = bipedBody.m_171599_("bipedHeadBaseRotator", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition bipedHead = bipedHeadBaseRotator.m_171599_("bipedHead", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(1, 91).m_171488_(-5.0f, -14.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition armorBipedHead = bipedHead.m_171599_("armorBipedHead", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition book = root.m_171599_("book", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-16.5f, (float)-9.0f));
        PartDefinition leftBookCover = book.m_171599_("leftBookCover", CubeListBuilder.m_171558_().m_171514_(26, 75).m_171488_(-8.0f, -5.0f, -1.0f, 8.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 63).m_171488_(-6.5f, -4.0f, -0.25f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leftPage = leftBookCover.m_171599_("leftPage", CubeListBuilder.m_171558_().m_171514_(44, 63).m_171488_(-6.5f, -4.0f, -0.24f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightBookCover = book.m_171599_("rightBookCover", CubeListBuilder.m_171558_().m_171514_(26, 63).m_171488_(0.0f, -5.0f, -1.0f, 8.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 63).m_171488_(0.5f, -4.0f, -0.25f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition rightPage = rightBookCover.m_171599_("rightPage", CubeListBuilder.m_171558_().m_171514_(44, 63).m_171488_(0.5f, -4.0f, -0.24f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.cape.f_104203_ = 0.1f + limbSwingAmount * 0.6f;
        AbstractIllager.IllagerArmPose abstractillager$illagerarmpose = ((EnchanterEntity)((Object)entity)).m_6768_();
        boolean bl = flag = abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSED;
        if (this.f_102609_ && abstractillager$illagerarmpose != AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.rightHand.f_104203_ = -0.62831855f;
            this.rightHand.f_104204_ = 0.0f;
            this.rightHand.f_104205_ = 0.0f;
            this.leftHand.f_104203_ = -0.62831855f;
            this.leftHand.f_104204_ = 0.0f;
            this.leftHand.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        }
        this.armorBipedRightArm.f_104207_ = false;
        this.armorBipedLeftArm.f_104207_ = false;
        this.illagerRightArm.f_104207_ = false;
        this.illagerLeftArm.f_104207_ = false;
        this.armorRightLeg.f_104207_ = false;
        this.armorLeftLeg.f_104207_ = false;
        this.rightHand.f_104207_ = false;
        this.leftHand.f_104207_ = false;
        this.m_267799_(EnchanterAnimation.ENCHANTER_MCD_WALK, limbSwing, limbSwingAmount, 3.0f, 4.5f);
        if (!((EnchanterEntity)((Object)entity)).castingAnimationState.m_216984_() && !((EnchanterEntity)((Object)entity)).attackAnimationState.m_216984_()) {
            this.m_267799_(EnchanterAnimation.ENCHANTER_IDLE, ageInTicks, 1.0f, 1.0f, 1.0f);
        }
        this.m_233381_(((EnchanterEntity)((Object)entity)).idleAnimationState, EnchanterAnimation.ENCHANTER_MCD_IDLE, ageInTicks);
        this.m_233385_(((EnchanterEntity)((Object)entity)).attackAnimationState, EnchanterAnimation.ENCHANTER_MCD_ATTACK, ageInTicks, 3.0f);
        this.m_233381_(((EnchanterEntity)((Object)entity)).castingAnimationState, EnchanterAnimation.ENCHANTER_MCD_CAST_SPELL, ageInTicks);
    }

    public ModelPart m_142109_() {
        return this.realRoot;
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        this.root.m_171324_("bipedLegs").m_104299_(poseStack);
        if (modelPart == this.armorRightLeg) {
            this.rightLeg.m_104299_(poseStack);
        } else {
            this.leftLeg.m_104299_(poseStack);
        }
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.75f, 0.0f);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        if (this.illagerRightArm == modelPart || this.illagerLeftArm == modelPart) {
            this.illagerArms.m_104299_(poseStack);
            modelPart.m_104299_(poseStack);
            if (modelPart == this.illagerRightArm) {
                poseStack.m_252880_(0.195f, 0.0f, 0.0f);
            } else {
                poseStack.m_252880_(-0.195f, 0.0f, 0.0f);
            }
        } else {
            this.bipedArms.m_104299_(poseStack);
            if (this.armorBipedRightArm == modelPart) {
                this.rightArm.m_104299_(poseStack);
            } else if (this.armorBipedLeftArm == modelPart) {
                this.leftArm.m_104299_(poseStack);
            }
            modelPart.m_104299_(poseStack);
        }
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.armorBipedRightArm, (Object)this.illagerRightArm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.armorBipedLeftArm, (Object)this.illagerLeftArm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.armorRightLeg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.armorLeftLeg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

