/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.command;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.command.MobEnchantArgument;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MobEnchantingCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_MOB_ENCHANT = (p_136344_, p_136345_) -> {
        Collection collection = MobEnchants.getRegistry().get().getValues();
        return SharedSuggestionProvider.m_82957_(collection.stream().map(mobenchant -> MobEnchants.getRegistry().get().getKey(mobenchant)), (SuggestionsBuilder)p_136345_);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder enchantCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"mob_enchanting").requires(player -> player.m_6761_(2));
        ((LiteralArgumentBuilder)enchantCommand.then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> MobEnchantingCommand.setClear((CommandSourceStack)ctx.getSource(), EntityArgument.m_91452_((CommandContext)ctx, (String)"target")))))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mob_enchantment", (ArgumentType)MobEnchantArgument.mobEnchantment()).executes(p_198357_0_ -> MobEnchantingCommand.setMobEnchants((CommandSourceStack)p_198357_0_.getSource(), EntityArgument.m_91452_((CommandContext)p_198357_0_, (String)"target"), MobEnchantArgument.getMobEnchant((CommandContext<CommandSourceStack>)p_198357_0_, "mob_enchantment"), 1))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(p_198357_0_ -> MobEnchantingCommand.setMobEnchants((CommandSourceStack)p_198357_0_.getSource(), EntityArgument.m_91452_((CommandContext)p_198357_0_, (String)"target"), MobEnchantArgument.getMobEnchant((CommandContext<CommandSourceStack>)p_198357_0_, "mob_enchantment"), IntegerArgumentType.getInteger((CommandContext)p_198357_0_, (String)"level")))))));
        dispatcher.register(enchantCommand);
        LiteralArgumentBuilder ancientEnchantCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"ancient_mob").requires(player -> player.m_6761_(2));
        ancientEnchantCommand.then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"ancient", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> MobEnchantingCommand.setAncientMob((CommandSourceStack)ctx.getSource(), EntityArgument.m_91452_((CommandContext)ctx, (String)"target"), BoolArgumentType.getBool((CommandContext)ctx, (String)"ancient")))));
        dispatcher.register(ancientEnchantCommand);
    }

    private static int setClear(CommandSourceStack commandStack, Entity entity) {
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                if (entity instanceof IEnchantCap) {
                    IEnchantCap enchantCap = (IEnchantCap)entity;
                    enchantCap.getEnchantCap().removeAllMobEnchant((LivingEntity)entity);
                    enchantCap.getEnchantCap().setEnchantType((LivingEntity)entity, MobEnchantCapability.EnchantType.NORMAL);
                }
                commandStack.m_288197_(() -> Component.m_237110_((String)"commands.enchantwithmob.mob_enchanting.clear", (Object[])new Object[]{entity.m_5446_()}), true);
                return 1;
            }
            commandStack.m_81352_((Component)Component.m_237110_((String)"commands.enchantwithmob.mob_enchanting.clear.fail.no_living_entity", (Object[])new Object[]{entity.m_5446_()}));
            return 0;
        }
        commandStack.m_81352_((Component)Component.m_237115_((String)"commands.enchantwithmob.mob_enchanting.clear.fail.no_entity"));
        return 0;
    }

    private static int setAncientMob(CommandSourceStack commandStack, Entity entity, boolean ancientMob) {
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                if (entity instanceof IEnchantCap) {
                    IEnchantCap enchantCap = (IEnchantCap)entity;
                    enchantCap.getEnchantCap().setEnchantType((LivingEntity)entity, ancientMob ? MobEnchantCapability.EnchantType.ANCIENT : MobEnchantCapability.EnchantType.NORMAL);
                }
                commandStack.m_288197_(() -> Component.m_237110_((String)"commands.enchantwithmob.ancient_mob.set_ancient", (Object[])new Object[]{entity.m_5446_()}), true);
                return 1;
            }
            commandStack.m_81352_((Component)Component.m_237110_((String)"commands.enchantwithmob.ancient_mobb.fail.no_living_entity", (Object[])new Object[]{entity.m_5446_()}));
            return 0;
        }
        commandStack.m_81352_((Component)Component.m_237115_((String)"commands.enchantwithmob.ancient_mob.fail.no_entity"));
        return 0;
    }

    private static int setMobEnchants(CommandSourceStack commandStack, Entity entity, MobEnchant mobEnchant, int level) {
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                if (mobEnchant != null) {
                    if (entity instanceof IEnchantCap) {
                        IEnchantCap enchantCap = (IEnchantCap)entity;
                        enchantCap.getEnchantCap().addMobEnchant((LivingEntity)entity, mobEnchant, level);
                    }
                    commandStack.m_288197_(() -> Component.m_237110_((String)"commands.enchantwithmob.mob_enchanting.set_enchant", (Object[])new Object[]{entity.m_5446_(), MobEnchants.getRegistry().get().getKey((Object)mobEnchant)}), true);
                    return 1;
                }
                commandStack.m_81352_((Component)Component.m_237115_((String)"commands.enchantwithmob.mob_enchanting.set_enchant.fail.no_mobenchant"));
                return 0;
            }
            commandStack.m_81352_((Component)Component.m_237110_((String)"commands.enchantwithmob.mob_enchanting.set_enchant.fail.no_living_entity", (Object[])new Object[]{entity.m_5446_()}));
            return 0;
        }
        commandStack.m_81352_((Component)Component.m_237115_((String)"commands.enchantwithmob.mob_enchanting.set_enchant.fail.no_entity"));
        return 0;
    }
}

