/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mixin;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.registry.ModTrackedDatas;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IEnchantCap {
    private static final EntityDataAccessor<MobEnchantCapability> MOB_ENCHANT_CAP = SynchedEntityData.m_135353_(LivingEntity.class, ModTrackedDatas.MOB_ENCHANT_CAPABILITY);

    public LivingEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo callbackInfo) {
        if ((this.getEnchantCap().getEnchantOwner().isPresent() || this.getEnchantCap().isFromOwner()) && this.getEnchantCap().hasEnchant()) {
            if (this.getEnchantCap().getEnchantOwner().isEmpty()) {
                LivingEntity livingEntity = (LivingEntity)this;
                this.getEnchantCap().removeMobEnchantFromOwner(livingEntity);
                this.m_5496_(SoundEvents.f_12018_, 1.5f, 1.6f);
            } else if (this.m_20280_((Entity)this.getEnchantCap().getEnchantOwner().get()) > 512.0) {
                LivingEntity livingEntity = (LivingEntity)this;
                this.getEnchantCap().removeMobEnchantFromOwner(livingEntity);
                this.m_5496_(SoundEvents.f_12018_, 1.5f, 1.6f);
            }
        }
    }

    @Inject(method={"onSyncedDataUpdated"}, at={@At(value="TAIL")})
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_21104_, CallbackInfo callbackInfo) {
        if (MOB_ENCHANT_CAP.equals(p_21104_)) {
            this.m_6210_();
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void defineSynchedData(CallbackInfo callbackInfo) {
        this.f_19804_.m_135372_(MOB_ENCHANT_CAP, (Object)new MobEnchantCapability());
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128365_("MobEnchantData", (Tag)this.getEnchantCap().serializeNBT());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        MobEnchantCapability mobEnchantCapability = new MobEnchantCapability();
        mobEnchantCapability.deserializeNBT(nbt.m_128469_("MobEnchantData"));
        this.setEnchantCap(mobEnchantCapability);
    }

    @Override
    public MobEnchantCapability getEnchantCap() {
        return (MobEnchantCapability)this.f_19804_.m_135370_(MOB_ENCHANT_CAP);
    }

    @Override
    public void setEnchantCap(MobEnchantCapability cap) {
        this.f_19804_.m_135381_(MOB_ENCHANT_CAP, (Object)cap);
    }
}

