/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.utils;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.utils.MobEnchantmentData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MobEnchantUtils {
    public static final String TAG_MOBENCHANT = "MobEnchant";
    public static final String TAG_ENCHANT_LEVEL = "EnchantLevel";
    public static final String TAG_STORED_MOBENCHANTS = "StoredMobEnchants";

    public static void executeIfPresent(Entity entity, MobEnchant mobEnchantment, Runnable runnable) {
        IEnchantCap cap;
        if (entity != null && entity instanceof IEnchantCap && MobEnchantUtils.findMobEnchantFromHandler((cap = (IEnchantCap)entity).getEnchantCap().getMobEnchants(), mobEnchantment)) {
            runnable.run();
        }
    }

    public static void executeIfPresent(Entity entity, Runnable runnable) {
        IEnchantCap cap;
        if (entity != null && entity instanceof IEnchantCap && (cap = (IEnchantCap)entity).getEnchantCap().hasEnchant()) {
            runnable.run();
        }
    }

    @Nullable
    public static MobEnchant getEnchantFromNBT(@Nullable CompoundTag tag) {
        if (tag != null && MobEnchants.getRegistry().get().containsKey(ResourceLocation.m_135820_((String)tag.m_128461_(TAG_MOBENCHANT)))) {
            return (MobEnchant)MobEnchants.getRegistry().get().getValue(ResourceLocation.m_135820_((String)tag.m_128461_(TAG_MOBENCHANT)));
        }
        return null;
    }

    public static int getEnchantLevelFromNBT(@Nullable CompoundTag tag) {
        if (tag != null) {
            return tag.m_128451_(TAG_ENCHANT_LEVEL);
        }
        return 0;
    }

    @Nullable
    public static MobEnchant getEnchantFromString(@Nullable String id) {
        if (id != null && MobEnchants.getRegistry().get().containsKey(ResourceLocation.m_135820_((String)id))) {
            return (MobEnchant)MobEnchants.getRegistry().get().getValue(ResourceLocation.m_135820_((String)id));
        }
        return null;
    }

    @Nullable
    public static MobEnchant getEnchantFromResourceLocation(@Nullable ResourceLocation id) {
        if (id != null && MobEnchants.getRegistry().get().containsKey(id)) {
            return (MobEnchant)MobEnchants.getRegistry().get().getValue(id);
        }
        return null;
    }

    public static boolean hasMobEnchant(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt != null && compoundnbt.m_128441_(TAG_STORED_MOBENCHANTS);
    }

    public static ListTag getEnchantmentListForNBT(CompoundTag compoundnbt) {
        return compoundnbt != null ? compoundnbt.m_128437_(TAG_STORED_MOBENCHANTS, 10) : new ListTag();
    }

    public static Map<MobEnchant, Integer> getEnchantments(ItemStack stack) {
        ListTag listnbt = MobEnchantUtils.getEnchantmentListForNBT(stack.m_41783_());
        return MobEnchantUtils.makeMobEnchantListFromListNBT(listnbt);
    }

    public static void setEnchantments(Map<MobEnchant, Integer> enchMap, ItemStack stack) {
        ListTag listnbt = new ListTag();
        for (Map.Entry<MobEnchant, Integer> entry : enchMap.entrySet()) {
            MobEnchant enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128359_(TAG_MOBENCHANT, String.valueOf(MobEnchants.getRegistry().get().getKey((Object)enchantment)));
            compoundnbt.m_128376_(TAG_ENCHANT_LEVEL, (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.m_41720_() != ModItems.MOB_ENCHANT_BOOK.get()) continue;
            MobEnchantUtils.addMobEnchantToItemStack(stack, enchantment, i);
        }
        if (listnbt.isEmpty()) {
            stack.m_41749_(TAG_STORED_MOBENCHANTS);
        }
    }

    private static Map<MobEnchant, Integer> makeMobEnchantListFromListNBT(ListTag p_226652_0_) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < p_226652_0_.size(); ++i) {
            CompoundTag compoundnbt = p_226652_0_.m_128728_(i);
            MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromString(compoundnbt.m_128461_(TAG_MOBENCHANT));
            map.put(mobEnchant, compoundnbt.m_128451_(TAG_ENCHANT_LEVEL));
        }
        return map;
    }

    public static void addMobEnchantToItemStack(ItemStack itemIn, MobEnchant mobenchant, int level) {
        ListTag listnbt = MobEnchantUtils.getEnchantmentListForNBT(itemIn.m_41783_());
        boolean flag = true;
        ResourceLocation resourcelocation = MobEnchants.getRegistry().get().getKey((Object)mobenchant);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            ResourceLocation resourcelocation1 = ResourceLocation.m_135820_((String)compoundnbt.m_128461_(TAG_MOBENCHANT));
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            if (compoundnbt.m_128451_(TAG_ENCHANT_LEVEL) < level) {
                compoundnbt.m_128405_(TAG_ENCHANT_LEVEL, level);
            }
            flag = false;
            break;
        }
        if (flag) {
            CompoundTag compoundnbt1 = new CompoundTag();
            compoundnbt1.m_128359_(TAG_MOBENCHANT, String.valueOf(resourcelocation));
            compoundnbt1.m_128405_(TAG_ENCHANT_LEVEL, level);
            listnbt.add((Object)compoundnbt1);
        }
        itemIn.m_41783_().m_128365_(TAG_STORED_MOBENCHANTS, (Tag)listnbt);
    }

    public static boolean addItemMobEnchantToEntity(ItemStack itemIn, LivingEntity entity, IEnchantCap capability) {
        ListTag listnbt = MobEnchantUtils.getEnchantmentListForNBT(itemIn.m_41783_());
        boolean flag = false;
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(MobEnchantUtils.getEnchantFromNBT(compoundnbt), entity, capability)) continue;
            capability.getEnchantCap().addMobEnchant(entity, MobEnchantUtils.getEnchantFromNBT(compoundnbt), MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt));
            flag = true;
        }
        return flag;
    }

    public static void removeMobEnchantToEntity(LivingEntity entity, IEnchantCap capability) {
        capability.getEnchantCap().removeAllMobEnchant(entity);
    }

    public static int getExperienceFromMob(IEnchantCap cap) {
        int l = 0;
        for (MobEnchantHandler list : cap.getEnchantCap().getMobEnchants()) {
            MobEnchant enchantment = list.getMobEnchant();
            int integer = list.getEnchantLevel();
            l += enchantment.getMinEnchantability(integer);
        }
        return l;
    }

    public static boolean addEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, MobEnchantmentData data) {
        boolean flag = false;
        if (MobEnchantUtils.checkAllowMobEnchantFromMob(data.enchantment, livingEntity, capability)) {
            capability.getEnchantCap().addMobEnchant(livingEntity, data.enchantment, data.enchantmentLevel, false);
            flag = true;
        }
        return flag;
    }

    public static boolean addEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, MobEnchantmentData data, boolean ancient) {
        boolean flag = false;
        if (MobEnchantUtils.checkAllowMobEnchantFromMob(data.enchantment, livingEntity, capability)) {
            capability.getEnchantCap().addMobEnchant(livingEntity, data.enchantment, data.enchantmentLevel, ancient);
            flag = true;
        }
        return flag;
    }

    public static boolean addRandomEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, RandomSource random, int level, boolean allowTresure, boolean allowCurse, boolean ancient) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowTresure, allowCurse);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.getEnchantCap().addMobEnchant(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel, ancient);
            flag = true;
        }
        return flag;
    }

    public static boolean addUnstableRandomEnchantmentToEntity(LivingEntity livingEntity, LivingEntity ownerEntity, IEnchantCap capability, RandomSource random, int level, boolean allowTresure, boolean allowCurse) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowTresure, allowCurse);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.getEnchantCap().addMobEnchantFromOwner(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel, ownerEntity);
            flag = true;
        }
        if (flag) {
            capability.getEnchantCap().addOwner(livingEntity, ownerEntity);
        }
        return flag;
    }

    public static ItemStack addRandomEnchantmentToItemStack(RandomSource random, ItemStack stack, int level, boolean allowRare, boolean allowCurse) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare, allowCurse);
        for (MobEnchantmentData enchantmentdata : list) {
            if (enchantmentdata.enchantment.isDisabled()) continue;
            MobEnchantUtils.addMobEnchantToItemStack(stack, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel);
        }
        return stack;
    }

    public static boolean findMobEnchantHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (!mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean findMobEnchant(List<MobEnchant> list, MobEnchant findMobEnchant) {
        return list.contains(findMobEnchant);
    }

    public static boolean findMobEnchantFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || findMobEnchant.isDisabled() || !mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllowMobEnchantFromMob(@Nullable MobEnchant mobEnchant, LivingEntity livingEntity, IEnchantCap capability) {
        if (mobEnchant != null && !mobEnchant.isCompatibleMob(livingEntity) && !((Boolean)EnchantConfig.COMMON.universalEnchant.get()).booleanValue()) {
            return false;
        }
        if (mobEnchant.isDisabled()) {
            return false;
        }
        for (MobEnchantHandler enchantHandler : capability.getEnchantCap().getMobEnchants()) {
            if (mobEnchant == null || enchantHandler.getMobEnchant() == null || enchantHandler.getMobEnchant().isCompatibleWith(mobEnchant)) continue;
            return false;
        }
        return mobEnchant != null;
    }

    public static int getMobEnchantLevelFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return mobEnchant.getEnchantLevel();
        }
        return 0;
    }

    public static List<MobEnchantmentData> buildEnchantmentList(RandomSource randomIn, int level, boolean allowTresure, boolean allowCursed) {
        ArrayList list = Lists.newArrayList();
        int i = 1;
        if (i <= 0) {
            return list;
        }
        level = level + 1 + randomIn.m_188503_(i / 4 + 1) + randomIn.m_188503_(i / 4 + 1);
        float f = (randomIn.m_188501_() + randomIn.m_188501_() - 1.0f) * 0.15f;
        List<MobEnchantmentData> list1 = MobEnchantUtils.makeMobEnchantmentDatas(level = Mth.m_14045_((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), allowTresure, allowCursed);
        if (!list1.isEmpty()) {
            WeightedRandom.m_216822_((RandomSource)randomIn, list1).ifPresent(list::add);
            while (randomIn.m_188503_(50) <= level) {
                if (!list.isEmpty()) {
                    MobEnchantUtils.removeIncompatible(list1, (MobEnchantmentData)((Object)Util.m_137509_((List)list)));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.m_216822_((RandomSource)randomIn, list1).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static List<MobEnchantmentData> makeMobEnchantmentDatas(int p_185291_0_, boolean allowTresure, boolean allowCursed) {
        ArrayList list = Lists.newArrayList();
        block0: for (MobEnchant enchantment : MobEnchants.getRegistry().get().getValues().stream().toList()) {
            if (enchantment.isCursedEnchant() && !allowCursed || enchantment.isTresureEnchant() && !allowTresure || enchantment.isOnlyChest()) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (p_185291_0_ < enchantment.getMinEnchantability(i) || p_185291_0_ > enchantment.getMaxEnchantability(i)) continue;
                list.add(new MobEnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    private static void removeIncompatible(List<MobEnchantmentData> dataList, MobEnchantmentData data) {
        Iterator<MobEnchantmentData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            if (data.enchantment.isCompatibleWith(iterator.next().enchantment) && !data.enchantment.isDisabled()) continue;
            iterator.remove();
        }
    }
}

