/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.client.model;

import bagu_chan.bagus_lib.client.layer.IArmor;
import baguchan.enchantwithmob.client.animation.EnchanterAnimation;
import baguchan.enchantwithmob.entity.Enchanter;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnchanterModel<T extends Enchanter>
extends HierarchicalModel<T>
implements IArmor {
    private final ModelPart realRoot;
    private final ModelPart everything;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart body;
    private final ModelPart Cape;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart righteyebrows;
    private final ModelPart lefteyebrows;
    private final ModelPart left_arm;
    private final ModelPart leftHand;
    private final ModelPart right_arm;
    private final ModelPart rightHand;
    private final ModelPart arms;
    private final ModelPart book;
    private final ModelPart leftBookCover;
    private final ModelPart rightBookCover;
    private final ModelPart pages;
    private final ModelPart leftPage;
    private final ModelPart leftPage2;

    public EnchanterModel(ModelPart root) {
        this.realRoot = root;
        this.everything = root.m_171324_("everything");
        this.left_leg = this.everything.m_171324_("left_leg");
        this.right_leg = this.everything.m_171324_("right_leg");
        this.body = this.everything.m_171324_("body");
        this.Cape = this.body.m_171324_("Cape");
        this.head = this.body.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.leftEye = this.head.m_171324_("leftEye");
        this.rightEye = this.head.m_171324_("rightEye");
        this.righteyebrows = this.head.m_171324_("righteyebrows");
        this.lefteyebrows = this.head.m_171324_("lefteyebrows");
        this.left_arm = this.body.m_171324_("left_arm");
        this.leftHand = this.left_arm.m_171324_("leftHand");
        this.right_arm = this.body.m_171324_("right_arm");
        this.rightHand = this.right_arm.m_171324_("rightHand");
        this.arms = this.body.m_171324_("arms");
        this.book = this.everything.m_171324_("book");
        this.leftBookCover = this.book.m_171324_("leftBookCover");
        this.rightBookCover = this.book.m_171324_("rightBookCover");
        this.pages = this.book.m_171324_("pages");
        this.leftPage = this.pages.m_171324_("leftPage");
        this.leftPage2 = this.pages.m_171324_("leftPage2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition everything = partdefinition.m_171599_("everything", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_leg = everything.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = everything.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = everything.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, -12.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition Cape = body.m_171599_("Cape", CubeListBuilder.m_171558_().m_171514_(0, 64).m_171488_(-6.0f, 0.0f, 0.0f, 12.0f, 23.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(1, 91).m_171488_(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(6, 5).m_171488_(0.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(6, 5).m_171488_(-1.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition righteyebrows = head.m_171599_("righteyebrows", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition righteyebrows_r1 = righteyebrows.m_171599_("righteyebrows_r1", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(-1.5f, -1.0f, -0.5902f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition lefteyebrows = head.m_171599_("lefteyebrows", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition lefteyebrows_r1 = lefteyebrows.m_171599_("lefteyebrows_r1", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171480_().m_171488_(-1.5f, -1.0f, -0.5902f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition leftHand = left_arm.m_171599_("leftHand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)11.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition rightHand = right_arm.m_171599_("rightHand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)11.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(40, 38).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)-0.95f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition book = everything.m_171599_("book", CubeListBuilder.m_171558_().m_171514_(43, 72).m_171488_(-2.0f, -3.0f, -1.0f, 3.0f, 9.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.5f, (float)-18.5f, (float)-9.0f));
        PartDefinition leftBookCover = book.m_171599_("leftBookCover", CubeListBuilder.m_171558_().m_171514_(26, 72).m_171480_().m_171488_(-8.0f, -3.0f, -1.0f, 8.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(44, 62).m_171488_(-6.9f, -2.5f, -0.5f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition rightBookCover = book.m_171599_("rightBookCover", CubeListBuilder.m_171558_().m_171514_(26, 62).m_171488_(0.0f, -3.0f, -1.0f, 8.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 62).m_171488_(-0.1f, -2.5f, -0.5f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition pages = book.m_171599_("pages", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)-0.1f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leftPage = pages.m_171599_("leftPage", CubeListBuilder.m_171558_().m_171514_(26, 82).m_171488_(-7.0f, -3.0f, 0.01f, 7.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition leftPage2 = pages.m_171599_("leftPage2", CubeListBuilder.m_171558_().m_171514_(26, 82).m_171488_(-7.0f, -3.0f, 0.01f, 7.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Cape.f_104203_ = 0.1f + limbSwingAmount * 0.6f;
        if (this.f_102609_) {
            this.m_288214_(EnchanterAnimation.SIT);
        }
        if (((Enchanter)((Object)entity)).castingAnimationState.m_216984_()) {
            this.m_233381_(((Enchanter)((Object)entity)).castingAnimationState, EnchanterAnimation.ENCHANCE, ageInTicks);
        } else if (((Enchanter)((Object)entity)).attackAnimationState.m_216984_()) {
            this.m_233381_(((Enchanter)((Object)entity)).attackAnimationState, EnchanterAnimation.ATTACK, ageInTicks);
        } else if (!((Enchanter)((Object)entity)).castingAnimationState.m_216984_() && !((Enchanter)((Object)entity)).attackAnimationState.m_216984_()) {
            if (!((Enchanter)((Object)entity)).idleAnimationState.m_216984_()) {
                this.m_267799_(EnchanterAnimation.WALK, limbSwing, limbSwingAmount, 3.0f, 4.5f);
                this.m_288214_(EnchanterAnimation.WALK_STOP);
            } else {
                this.m_233381_(((Enchanter)((Object)entity)).idleAnimationState, EnchanterAnimation.IDLE, ageInTicks);
            }
        }
    }

    public ModelPart m_142109_() {
        return this.realRoot;
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.everything.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -0.2f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.everything.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -0.75f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.everything.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.everything.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        if (this.rightHand == modelPart) {
            this.right_arm.m_104299_(poseStack);
        }
        if (this.leftHand == modelPart) {
            this.left_arm.m_104299_(poseStack);
        }
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -0.75f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.right_leg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.left_leg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.rightHand);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.leftHand);
    }
}

