/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.message;

import baguchan.enchantwithmob.api.IEnchantCap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MobEnchantFromOwnerMessage {
    private int entityId;
    private int ownerID;

    public MobEnchantFromOwnerMessage(Entity entity, Entity ownerEntity) {
        this.entityId = entity.m_19879_();
        this.ownerID = ownerEntity.m_19879_();
    }

    public MobEnchantFromOwnerMessage(int id, int ownerID) {
        this.entityId = id;
        this.ownerID = ownerID;
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.ownerID);
    }

    public static MobEnchantFromOwnerMessage deserialize(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        int ownerId = buffer.readInt();
        return new MobEnchantFromOwnerMessage(entityId, ownerId);
    }

    public static boolean handle(MobEnchantFromOwnerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.entityId);
                Entity ownerEntity = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.ownerID);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (ownerEntity instanceof LivingEntity && livingEntity instanceof IEnchantCap) {
                        IEnchantCap cap = (IEnchantCap)livingEntity;
                        cap.getEnchantCap().addOwner((LivingEntity)entity, (LivingEntity)ownerEntity);
                    }
                }
            });
        }
        return true;
    }
}

