/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mixin;

import bagu_chan.bagus_lib.api.IBaguPacket;
import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.message.MobEnchantedMessage;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IEnchantCap,
IBaguPacket {
    public MobEnchantCapability capability = new MobEnchantCapability();

    public LivingEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo callbackInfo) {
        if ((this.getEnchantCap().hasOwner() || this.getEnchantCap().isFromOwner()) && this.getEnchantCap().hasEnchant()) {
            if (this.getEnchantCap().getEnchantOwner() == null || !this.getEnchantCap().getEnchantOwner().m_6084_()) {
                LivingEntity livingEntity = (LivingEntity)this;
                this.getEnchantCap().removeMobEnchantFromOwner(livingEntity);
                this.m_5496_(SoundEvents.f_12018_, 1.5f, 1.6f);
            } else if (this.m_20280_((Entity)this.getEnchantCap().getEnchantOwner()) > 512.0) {
                LivingEntity livingEntity = (LivingEntity)this;
                this.getEnchantCap().removeMobEnchantFromOwner(livingEntity);
                this.m_5496_(SoundEvents.f_12018_, 1.5f, 1.6f);
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128365_("MobEnchantData", (Tag)this.getEnchantCap().serializeNBT());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        MobEnchantCapability mobEnchantCapability = new MobEnchantCapability();
        mobEnchantCapability.deserializeNBT(nbt.m_128469_("MobEnchantData"));
        this.setEnchantCap(mobEnchantCapability);
    }

    @Override
    public MobEnchantCapability getEnchantCap() {
        return this.capability;
    }

    @Override
    public void setEnchantCap(MobEnchantCapability cap) {
        this.capability = cap;
    }

    @Inject(method={"getVoicePitch"}, at={@At(value="RETURN")}, cancellable=true)
    public void getVoicePitch(CallbackInfoReturnable<Float> cir) {
        int fastTime = Mth.m_14045_((int)MobEnchantUtils.getMobEnchantLevelFromHandler(this.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.FAST.get()), (int)0, (int)2);
        int slowTime = Mth.m_14045_((int)MobEnchantUtils.getMobEnchantLevelFromHandler(this.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.SLOW.get()), (int)0, (int)2);
        float different = Mth.m_14036_((float)(((Float)cir.getReturnValue()).floatValue() + (float)fastTime * 0.125f - (float)slowTime * 0.125f), (float)0.1f, (float)2.0f);
        cir.setReturnValue((Object)Float.valueOf(different));
    }

    public void resync(Entity entity, int id) {
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < this.getEnchantCap().getMobEnchants().size(); ++i) {
                MobEnchantedMessage message = new MobEnchantedMessage(this, this.getEnchantCap().getMobEnchants().get(i));
                EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)message);
            }
        }
    }

    @Shadow
    public boolean m_6162_() {
        return false;
    }
}

