/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.capability.ItemMobEnchantCapability;
import baguchan.enchantwithmob.command.MobEnchantingCommand;
import baguchan.enchantwithmob.message.AncientMessage;
import baguchan.enchantwithmob.message.MobEnchantFromOwnerMessage;
import baguchan.enchantwithmob.message.MobEnchantedMessage;
import baguchan.enchantwithmob.message.RemoveAllMobEnchantMessage;
import baguchan.enchantwithmob.message.RemoveMobEnchantOwnerMessage;
import baguchan.enchantwithmob.message.SoulParticleMessage;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModArgumentTypeInfos;
import baguchan.enchantwithmob.registry.ModEntities;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.registry.ModLootItemFunctions;
import baguchan.enchantwithmob.registry.ModTrackedDatas;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enchantwithmob")
public class EnchantWithMob {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "enchantwithmob";
    public static final String NETWORK_PROTOCOL = "2";
    public static final SimpleChannel CHANNEL = ChannelBuilder.named((ResourceLocation)new ResourceLocation("enchantwithmob", "net")).networkProtocolVersion(2).simpleChannel();
    public static Capability<ItemMobEnchantCapability> ITEM_MOB_ENCHANT_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ItemMobEnchantCapability>(){});

    public EnchantWithMob() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.setupMessages();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MobEnchants.MOB_ENCHANT.register(bus);
        ModArgumentTypeInfos.COMMAND_ARGUMENT_TYPES.register(bus);
        ModEntities.ENTITIES_REGISTRY.register(bus);
        ModItems.ITEM_REGISTRY.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EnchantConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EnchantConfig.CLIENT_SPEC);
    }

    private void setup(FMLCommonSetupEvent event) {
        ModTrackedDatas.init();
        ModLootItemFunctions.init();
        Raid.RaiderType.create((String)"enchanter", (EntityType)((EntityType)ModEntities.ENCHANTER.get()), (int[])new int[]{0, 0, 1, 0, 1, 1, 2, 1});
    }

    private void setupMessages() {
        CHANNEL.messageBuilder(SoulParticleMessage.class, 0).encoder(SoulParticleMessage::serialize).decoder(SoulParticleMessage::deserialize).consumerMainThread(SoulParticleMessage::handle).add();
        CHANNEL.messageBuilder(AncientMessage.class, 1).encoder(AncientMessage::serialize).decoder(AncientMessage::deserialize).consumerMainThread(AncientMessage::handle).add();
        CHANNEL.messageBuilder(MobEnchantedMessage.class, 2).encoder(MobEnchantedMessage::serialize).decoder(MobEnchantedMessage::deserialize).consumerMainThread(MobEnchantedMessage::handle).add();
        CHANNEL.messageBuilder(MobEnchantFromOwnerMessage.class, 3).encoder(MobEnchantFromOwnerMessage::serialize).decoder(MobEnchantFromOwnerMessage::deserialize).consumerMainThread(MobEnchantFromOwnerMessage::handle).add();
        CHANNEL.messageBuilder(RemoveAllMobEnchantMessage.class, 4).encoder(RemoveAllMobEnchantMessage::serialize).decoder(RemoveAllMobEnchantMessage::deserialize).consumerMainThread(RemoveAllMobEnchantMessage::handle).add();
        CHANNEL.messageBuilder(RemoveMobEnchantOwnerMessage.class, 6).encoder(RemoveMobEnchantOwnerMessage::serialize).decoder(RemoveMobEnchantOwnerMessage::deserialize).consumerMainThread(RemoveMobEnchantOwnerMessage::handle).add();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        MobEnchantingCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }
}

