/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.entity;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import baguchan.enchantwithmob.utils.MobEnchantmentData;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnchanterEntity
extends SpellcasterIllager {
    private LivingEntity enchantTarget;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState castingAnimationState = new AnimationState();
    public int attackAnimationTick;
    public final int attackAnimationLength = 19;
    public final int attackAnimationActionPoint = 10;
    public int castingAnimationTick;
    public final int castingAnimationLength = 72;

    public EnchanterEntity(EntityType<? extends EnchanterEntity> type, Level p_i48551_2_) {
        super(type, p_i48551_2_);
        this.f_21364_ = 12;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, new AvoidTargetEntityGoal<Mob>(this, Mob.class, 6.5f, 0.8, 1.05));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.8, 1.15));
        this.f_21345_.m_25352_(4, (Goal)new SpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_9236_().f_46443_) {
            if (this.attackAnimationTick < this.attackAnimationLength) {
                ++this.attackAnimationTick;
            }
            if (this.attackAnimationTick >= this.attackAnimationLength) {
                this.attackAnimationState.m_216973_();
            }
            if (this.castingAnimationTick < this.castingAnimationLength) {
                ++this.castingAnimationTick;
            }
            if (this.castingAnimationTick >= this.castingAnimationLength) {
                this.castingAnimationState.m_216973_();
            }
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
            this.idleAnimationState.m_216973_();
            this.castingAnimationState.m_216973_();
            this.attackAnimationTick = 0;
        } else if (p_21375_ == 61) {
            this.castingAnimationState.m_216977_(this.f_19797_);
            this.idleAnimationState.m_216973_();
            this.attackAnimationState.m_216973_();
            this.castingAnimationTick = 0;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public static AttributeSupplier.Builder createAttributeMap() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.attackAnimationState.m_216984_() || this.castingAnimationState.m_216984_() || this.f_20916_ > 0 || this.f_267362_.m_267780_()) {
            this.idleAnimationState.m_216973_();
        } else {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
    }

    public boolean m_7307_(Entity p_184191_1_) {
        if (super.m_7307_(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && p_184191_1_.m_5647_() == null;
        }
        return false;
    }

    private void setEnchantTarget(@Nullable LivingEntity enchantTargetIn) {
        this.enchantTarget = enchantTargetIn;
    }

    @Nullable
    public LivingEntity getEnchantTarget() {
        return this.enchantTarget;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        if (this.f_19796_.m_188501_() < 0.25f + 0.025f * (float)looting) {
            if (this.f_37836_ != null && this.m_37886_() && this.m_37887_() > 0) {
                ItemStack itemStack = new ItemStack((ItemLike)ModItems.ENCHANTERS_BOOK.get());
                if (this.f_19796_.m_188501_() < 0.5f) {
                    itemStack = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.get());
                }
                this.m_19983_(MobEnchantUtils.addRandomEnchantmentToItemStack(this.f_19796_, itemStack, 20 + this.m_37887_() * 4, true, false));
            } else {
                ItemStack itemStack = new ItemStack((ItemLike)ModItems.ENCHANTERS_BOOK.get());
                if (this.f_19796_.m_188501_() < 0.5f) {
                    itemStack = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.get());
                }
                this.m_19983_(MobEnchantUtils.addRandomEnchantmentToItemStack(this.f_19796_, itemStack, 20, true, false));
            }
        }
    }

    public boolean m_7490_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12050_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12051_;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11887_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
        EnchanterEntity enchanterEntity;
        boolean flag;
        Raid raid = this.m_37885_();
        boolean bl = flag = this.f_19796_.m_188501_() <= raid.m_37783_() + 0.1f;
        if (flag && (enchanterEntity = this) instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)((Object)enchanterEntity);
            MobEnchantUtils.addEnchantmentToEntity((LivingEntity)this, cap, new MobEnchantmentData((MobEnchant)MobEnchants.PROTECTION.get(), 2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_33736_()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private CastingSpellGoal() {
            super((SpellcasterIllager)EnchanterEntity.this);
        }

        public void m_8037_() {
            if (EnchanterEntity.this.m_33736_() && EnchanterEntity.this.getEnchantTarget() != null) {
                EnchanterEntity.this.m_21563_().m_24960_((Entity)EnchanterEntity.this.getEnchantTarget(), (float)EnchanterEntity.this.m_8085_(), (float)EnchanterEntity.this.m_8132_());
            } else if (EnchanterEntity.this.m_33736_() && EnchanterEntity.this.m_5448_() != null) {
                EnchanterEntity.this.m_21563_().m_24960_((Entity)EnchanterEntity.this.m_5448_(), (float)EnchanterEntity.this.m_8085_(), (float)EnchanterEntity.this.m_8132_());
            }
        }
    }

    static class AttackGoal
    extends Goal {
        private final EnchanterEntity enchanter;
        private int tick;

        AttackGoal(EnchanterEntity enchanter) {
            this.enchanter = enchanter;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.enchanter.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return this.getAttackReachSqr(livingentity) >= this.enchanter.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.tick < this.enchanter.attackAnimationLength;
        }

        public void m_8056_() {
            super.m_8056_();
            this.enchanter.m_9236_().m_7605_((Entity)this.enchanter, (byte)4);
        }

        public void m_8041_() {
            super.m_8041_();
            this.tick = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity livingentity = this.enchanter.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.enchanter.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                if (this.getAttackReachSqr(livingentity) >= this.enchanter.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_())) {
                    if (this.tick == this.enchanter.attackAnimationActionPoint) {
                        this.enchanter.m_6674_(InteractionHand.MAIN_HAND);
                        this.enchanter.m_7327_((Entity)livingentity);
                        this.enchanter.m_216990_(SoundEvents.f_12048_);
                    }
                    this.enchanter.m_21573_().m_26573_();
                }
            }
            ++this.tick;
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return this.enchanter.m_20205_() * 1.5f * this.enchanter.m_20205_() * 1.5f + attackTarget.m_20205_();
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AvoidTargetEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final EnchanterEntity enchanter;

        public AvoidTargetEntityGoal(EnchanterEntity enchanterIn, Class<T> entityClassToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super((PathfinderMob)enchanterIn, entityClassToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
            this.enchanter = enchanterIn;
        }

        public boolean m_8036_() {
            if (super.m_8036_() && this.f_25016_ == this.enchanter.m_5448_()) {
                return this.enchanter.m_5448_() != null;
            }
            return false;
        }

        public void m_8056_() {
            EnchanterEntity.this.m_6710_(null);
            super.m_8056_();
        }

        public void m_8037_() {
            EnchanterEntity.this.m_6710_(null);
            super.m_8037_();
        }
    }

    public class SpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final Predicate<LivingEntity> fillter;
        private final Predicate<LivingEntity> enchanted_fillter;

        public SpellGoal() {
            super((SpellcasterIllager)EnchanterEntity.this);
            this.fillter = entity -> {
                IEnchantCap enchantCap;
                return !(entity instanceof EnchanterEntity) && entity instanceof IEnchantCap && !(enchantCap = (IEnchantCap)entity).getEnchantCap().hasEnchant();
            };
            this.enchanted_fillter = entity -> {
                IEnchantCap enchantCap;
                return !(entity instanceof EnchanterEntity) && entity instanceof IEnchantCap && (enchantCap = (IEnchantCap)entity).getEnchantCap().hasEnchant();
            };
        }

        public boolean m_8036_() {
            if (EnchanterEntity.this.m_5448_() == null) {
                return false;
            }
            if (EnchanterEntity.this.m_33736_()) {
                return false;
            }
            if (EnchanterEntity.this.f_19797_ < this.f_33775_) {
                return false;
            }
            List list = EnchanterEntity.this.m_9236_().m_6443_(LivingEntity.class, EnchanterEntity.this.m_20191_().m_82363_(16.0, 8.0, 16.0), this.fillter);
            if (list.isEmpty()) {
                return false;
            }
            List enchanted_list = EnchanterEntity.this.m_9236_().m_6443_(LivingEntity.class, EnchanterEntity.this.m_20191_().m_82363_(16.0, 8.0, 16.0), this.enchanted_fillter);
            if (enchanted_list.size() < 5) {
                LivingEntity target = (LivingEntity)list.get(EnchanterEntity.this.f_19796_.m_188503_(list.size()));
                if (target != EnchanterEntity.this.m_5448_() && target != EnchanterEntity.this && target.m_7307_((Entity)EnchanterEntity.this) && EnchanterEntity.this.m_7307_((Entity)target) && (target.m_5647_() == EnchanterEntity.this.m_5647_() || target.m_6336_() == MobType.f_21643_ && target.m_5647_() == null)) {
                    EnchanterEntity.this.setEnchantTarget(target);
                    EnchanterEntity.this.m_9236_().m_7605_((Entity)EnchanterEntity.this, (byte)61);
                    return true;
                }
                return false;
            }
            return false;
        }

        public boolean m_8045_() {
            return EnchanterEntity.this.getEnchantTarget() != null && EnchanterEntity.this.getEnchantTarget() != EnchanterEntity.this.m_5448_() && this.f_33774_ > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            EnchanterEntity.this.setEnchantTarget(null);
        }

        protected void m_8130_() {
            LivingEntity entity = EnchanterEntity.this.getEnchantTarget();
            if (entity != null && entity.m_6084_() && entity instanceof IEnchantCap) {
                IEnchantCap cap = (IEnchantCap)entity;
                MobEnchantUtils.addUnstableRandomEnchantmentToEntity(entity, (LivingEntity)EnchanterEntity.this, cap, entity.m_217043_(), 12, false, false);
            }
        }

        protected int m_8069_() {
            return 40;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 200;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11713_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

