/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.loot;

import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.registry.ModLootItemFunctions;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class MobEnchantRandomlyFunction
extends LootItemConditionalFunction {
    private static final Codec<MobEnchant> ENCHANTMENT_SET_CODEC = ExtraCodecs.m_184415_(() -> MobEnchants.getRegistry().get().getCodec());
    public static final Codec<MobEnchantRandomlyFunction> CODEC = RecordCodecBuilder.create(p_297085_ -> MobEnchantRandomlyFunction.m_294820_((RecordCodecBuilder.Instance)p_297085_).and((App)Codec.list(ENCHANTMENT_SET_CODEC).fieldOf("mob_enchant").forGetter(p_297084_ -> p_297084_.enchantments)).apply((Applicative)p_297085_, MobEnchantRandomlyFunction::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    final List<MobEnchant> enchantments;

    public MobEnchantRandomlyFunction(List<LootItemCondition> p_80418_, Collection<MobEnchant> p_80419_) {
        super(p_80418_);
        this.enchantments = ImmutableList.copyOf(p_80419_);
    }

    public LootItemFunctionType m_7162_() {
        return ModLootItemFunctions.MOB_ENCHANT_RANDOMLY_FUNCTION;
    }

    public ItemStack m_7372_(ItemStack p_80429_, LootContext p_80430_) {
        MobEnchant enchantment;
        RandomSource randomsource = p_80430_.m_230907_();
        if (this.enchantments.isEmpty()) {
            boolean flag = p_80429_.m_150930_(Items.f_42517_) || p_80429_.m_150930_((Item)ModItems.MOB_ENCHANT_BOOK.get());
            List list = MobEnchants.getRegistry().get().getValues().stream().filter(MobEnchant::isOnlyChest).filter(p_80436_ -> flag).collect(Collectors.toList());
            if (list.isEmpty()) {
                LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)p_80429_);
                return p_80429_;
            }
            enchantment = (MobEnchant)list.get(randomsource.m_188503_(list.size()));
        } else {
            enchantment = this.enchantments.get(randomsource.m_188503_(this.enchantments.size()));
        }
        return MobEnchantRandomlyFunction.enchantItem(p_80429_, enchantment, randomsource);
    }

    private static ItemStack enchantItem(ItemStack p_230980_, MobEnchant p_230981_, RandomSource p_230982_) {
        int i = Mth.m_216271_((RandomSource)p_230982_, (int)p_230981_.getMinLevel(), (int)p_230981_.getMaxLevel());
        if (p_230980_.m_150930_(Items.f_42517_)) {
            p_230980_ = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.get());
            MobEnchantUtils.addMobEnchantToItemStack(p_230980_, p_230981_, i);
        } else {
            MobEnchantUtils.addMobEnchantToItemStack(p_230980_, p_230981_, i);
        }
        return p_230980_;
    }

    public static Builder randomMobEnchant() {
        return new Builder();
    }

    public static LootItemConditionalFunction.Builder<?> randomApplicableMobEnchant() {
        return MobEnchantRandomlyFunction.m_80683_(p_80438_ -> new MobEnchantRandomlyFunction((List<LootItemCondition>)p_80438_, (Collection<MobEnchant>)ImmutableList.of()));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Set<MobEnchant> enchantments = Sets.newHashSet();

        protected Builder getThis() {
            return this;
        }

        public Builder withMobEnchant(MobEnchant p_80445_) {
            this.enchantments.add(p_80445_);
            return this;
        }

        public LootItemFunction m_7453_() {
            return new MobEnchantRandomlyFunction(this.m_80699_(), this.enchantments);
        }
    }
}

