/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.message;

import baguchan.enchantwithmob.api.IEnchantCap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.LogicalSide;

public class MobEnchantFromOwnerMessage {
    private int entityId;
    private int ownerID;

    public MobEnchantFromOwnerMessage(Entity entity, Entity ownerEntity) {
        this.entityId = entity.m_19879_();
        this.ownerID = ownerEntity.m_19879_();
    }

    public MobEnchantFromOwnerMessage(int id, int ownerID) {
        this.entityId = id;
        this.ownerID = ownerID;
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.ownerID);
    }

    public static MobEnchantFromOwnerMessage deserialize(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        int ownerId = buffer.readInt();
        return new MobEnchantFromOwnerMessage(entityId, ownerId);
    }

    public void handle(CustomPayloadEvent.Context context) {
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                LivingEntity livingEntity;
                Entity entity = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(this.entityId);
                Entity ownerEntity = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(this.ownerID);
                if (entity != null && entity instanceof LivingEntity && ownerEntity != null && ownerEntity instanceof LivingEntity && (livingEntity = (LivingEntity)ownerEntity) instanceof IEnchantCap) {
                    IEnchantCap cap = (IEnchantCap)livingEntity;
                    cap.getEnchantCap().addOwner((LivingEntity)entity, (LivingEntity)ownerEntity);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

